/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.minecraft.class_12087;
import net.minecraft.class_12094;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class AutoCommand
implements DedicatedServerModInitializer {
    static final String VALUE = "value";
    Field field;
    Class<?> type;
    String modid;
    boolean isList;

    public AutoCommand() {
    }

    public AutoCommand(Field field, String modid) {
        this.field = field;
        this.modid = modid;
        this.type = MidnightConfig.getUnderlyingType(field);
        this.isList = field.getType() == List.class;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)field.getName()).executes(this::getValue);
        if (this.type.isEnum()) {
            for (Object enumValue : field.getType().getEnumConstants()) {
                command = (LiteralArgumentBuilder)command.then(class_2170.method_9247((String)enumValue.toString()).executes(ctx -> this.setValue((class_2168)ctx.getSource(), enumValue, "")));
            }
        } else if (this.isList) {
            for (String action : new String[]{"add", "remove"}) {
                command = (LiteralArgumentBuilder)command.then(class_2170.method_9247((String)action).then(class_2170.method_9244((String)VALUE, this.getArgType()).executes(ctx -> this.setValueFromArg((CommandContext<class_2168>)ctx, action))));
            }
        } else {
            command = (LiteralArgumentBuilder)command.then(class_2170.method_9244((String)VALUE, this.getArgType()).executes(ctx -> this.setValueFromArg((CommandContext<class_2168>)ctx, "")));
        }
        PlatformFunctions.registerCommand((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"midnightconfig").requires(source -> source.method_75037().hasPermission((class_12087)new class_12087.class_12089(class_12094.field_63198)))).then(class_2170.method_9247((String)modid).then((ArgumentBuilder)command))));
    }

    public ArgumentType<?> getArgType() {
        MidnightConfig.Entry entry = this.field.getAnnotation(MidnightConfig.Entry.class);
        if (this.type == Integer.TYPE) {
            return IntegerArgumentType.integer((int)((int)entry.min()), (int)((int)entry.max()));
        }
        if (this.type == Double.TYPE) {
            return DoubleArgumentType.doubleArg((double)entry.min(), (double)entry.max());
        }
        if (this.type == Float.TYPE) {
            return FloatArgumentType.floatArg((float)((float)entry.min()), (float)((float)entry.max()));
        }
        if (this.type == Boolean.TYPE) {
            return BoolArgumentType.bool();
        }
        return StringArgumentType.string();
    }

    public int setValueFromArg(CommandContext<class_2168> context, String action) {
        if (this.type == Integer.TYPE) {
            return this.setValue((class_2168)context.getSource(), IntegerArgumentType.getInteger(context, (String)VALUE), action);
        }
        if (this.type == Double.TYPE) {
            return this.setValue((class_2168)context.getSource(), DoubleArgumentType.getDouble(context, (String)VALUE), action);
        }
        if (this.type == Float.TYPE) {
            return this.setValue((class_2168)context.getSource(), Float.valueOf(FloatArgumentType.getFloat(context, (String)VALUE)), action);
        }
        if (this.type == Boolean.TYPE) {
            return this.setValue((class_2168)context.getSource(), BoolArgumentType.getBool(context, (String)VALUE), action);
        }
        return this.setValue((class_2168)context.getSource(), StringArgumentType.getString(context, (String)VALUE), action);
    }

    private int setValue(class_2168 source, Object value, String action) {
        boolean add = Objects.equals(action, "add");
        try {
            if (!this.isList) {
                this.field.set(null, value);
            } else {
                List list = (List)this.field.get(null);
                if (add) {
                    list.add(value);
                } else {
                    if (!list.contains(value)) {
                        throw new IllegalArgumentException("List does not contain this string!");
                    }
                    list.remove(value);
                }
            }
            MidnightConfig.write(this.modid);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)(this.isList ? "Could not %s %s %s %s: %s".formatted(add ? "add" : "remove", value, add ? "to" : "from", this.field.getName(), e) : "Could not set %s to value %s: %s".formatted(this.field.getName(), value, e))));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)(this.isList ? "Successfully %s %s %s %s".formatted(add ? "added" : "removed", value, add ? "to" : "from", this.field.getName()) : "Successfully set %s to %s".formatted(this.field.getName(), value))), true);
        return 1;
    }

    private int getValue(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> {
            try {
                return class_2561.method_43470((String)"The value of %s is %s".formatted(this.field.getName(), this.field.get(null)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, true);
        return 0;
    }

    public void onInitializeServer() {
        MidnightConfig.configInstances.forEach((modid, config) -> {
            for (Field field : config.configClass.getFields()) {
                if (!field.isAnnotationPresent(MidnightConfig.Entry.class) || field.isAnnotationPresent(MidnightConfig.Client.class) || field.isAnnotationPresent(MidnightConfig.Hidden.class)) continue;
                new AutoCommand(field, (String)modid);
            }
        });
    }
}

