/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.platform;

import architectury_inject_architectury_common_3962ebec8961472c83540874a1258a74_89a3c9c79297b32fe4e64da4fd992b85be8476b7ddf9061f1d76192431964594architectury1901devjar.PlatformMethods;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Mod;
import dev.architectury.platform.fabric.PlatformImpl;
import dev.architectury.utils.Env;
import java.nio.file.Path;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.minecraft.class_155;

public final class Platform {
    private static int simpleLoaderCache = -1;

    private Platform() {
    }

    public static boolean isFabric() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 0;
    }

    @Deprecated(forRemoval=true)
    public static boolean isForge() {
        return Platform.isForgeLike();
    }

    public static boolean isForgeLike() {
        return Platform.isMinecraftForge() || Platform.isNeoForge();
    }

    public static boolean isMinecraftForge() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 1;
    }

    public static boolean isNeoForge() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 2;
    }

    private static void updateLoaderCache() {
        if (simpleLoaderCache != -1) {
            return;
        }
        switch (PlatformMethods.getCurrentTarget()) {
            case "fabric": {
                simpleLoaderCache = 0;
                break;
            }
            case "forge": {
                simpleLoaderCache = 1;
                break;
            }
            case "neoforge": {
                simpleLoaderCache = 2;
            }
        }
    }

    public static String getMinecraftVersion() {
        return class_155.method_16673().comp_4024();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameFolder() {
        return PlatformImpl.getGameFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigFolder() {
        return PlatformImpl.getConfigFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getModsFolder() {
        return PlatformImpl.getModsFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Env getEnvironment() {
        return PlatformImpl.getEnvironment();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EnvType getEnv() {
        return PlatformImpl.getEnv();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String id) {
        return PlatformImpl.isModLoaded(id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Mod getMod(String id) {
        return PlatformImpl.getMod(id);
    }

    public static Optional<Mod> getOptionalMod(String id) {
        try {
            return Optional.of(Platform.getMod(id));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<Mod> getMods() {
        return PlatformImpl.getMods();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<String> getModIds() {
        return PlatformImpl.getModIds();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopmentEnvironment() {
        return PlatformImpl.isDevelopmentEnvironment();
    }
}

