/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.mixin.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import malte0811.ferritecore.mixin.config.IPlatformConfigHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FerriteConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FerriteConfig.class);
    public static final Option NEIGHBOR_LOOKUP;
    public static final Option PROPERTY_MAP;
    public static final Option PREDICATES;
    public static final Option MRL_CACHE;
    public static final Option DEDUP_MULTIPART;
    public static final Option DEDUP_BLOCKSTATE_CACHE;
    public static final Option DEDUP_QUADS;
    public static final Option COMPACT_FAST_MAP;
    public static final Option POPULATE_NEIGHBOR_TABLE;
    public static final Option THREADING_DETECTOR;
    public static final Option MODEL_SIDES;
    public static final Option DATACOMPONENTS;

    static {
        ConfigBuilder builder = new ConfigBuilder();
        NEIGHBOR_LOOKUP = builder.createOption("replaceNeighborLookup", "Replace the blockstate neighbor table", new Option[0]);
        PROPERTY_MAP = builder.createOption("replacePropertyMap", "Do not store the properties of a state explicitly and read themfrom the replace neighbor table instead. Requires " + NEIGHBOR_LOOKUP.getName() + " to be enabled", NEIGHBOR_LOOKUP);
        PREDICATES = builder.createOption("cacheMultipartPredicates", "Cache the predicate instances used in multipart models", new Option[0]);
        MRL_CACHE = builder.createOption("modelResourceLocations", "Avoid creation of new strings when creating ModelResourceLocations", new Option[0]);
        DEDUP_MULTIPART = builder.createOption("multipartDeduplication", "Do not create a new MultipartBakedModel instance for each block state using the same multipartmodel. Requires " + PREDICATES.getName() + " to be enabled", PREDICATES);
        DEDUP_BLOCKSTATE_CACHE = builder.createOption("blockstateCacheDeduplication", "Deduplicate cached data for blockstates, most importantly collision and render shapes", new Option[0]);
        DEDUP_QUADS = builder.createOption("bakedQuadDeduplication", "Deduplicate vertex data of baked quads in the basic model implementations", new Option[0]);
        MODEL_SIDES = builder.createOption("modelSides", "Use smaller data structures for \"simple\" models, especially models with few side-specific faces", new Option[0]);
        DATACOMPONENTS = builder.createOption("dataComponentPatch", "Save memory overhead from empty data component maps/patched", new Option[0]);
        THREADING_DETECTOR = builder.createOptInOption("useSmallThreadingDetector", "Replace objects used to detect multi-threaded access to chunks by a much smaller field. This option is disabled by default due to very rare and very hard-to-reproduce crashes, use at your own risk!", new Option[0]);
        COMPACT_FAST_MAP = builder.createOptInOption("compactFastMap", "Use a slightly more compact, but also slightly slower representation for block states", new Option[0]);
        POPULATE_NEIGHBOR_TABLE = builder.createOptInOption("populateNeighborTable", "Populate the neighbor table used by vanilla. Enabling this slightly increases memory usage, but can help with issues in the rare case where mods access it directly.", new Option[0]);
        builder.finish();
    }

    public static class ConfigBuilder {
        private final List<Option> options = new ArrayList<Option>();

        public Option createOption(String name, String comment, Option ... dependencies) {
            Option result = new Option(name, comment, true, dependencies);
            this.options.add(result);
            return result;
        }

        public Option createOptInOption(String name, String comment, Option ... dependencies) {
            Option result = new Option(name, comment, false, dependencies);
            this.options.add(result);
            return result;
        }

        private void finish() {
            IPlatformConfigHooks platformHooks = IPlatformConfigHooks.loadHooks();
            try {
                platformHooks.readAndUpdateConfig(this.options);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Set allOptions = this.options.stream().map(Option::getName).collect(Collectors.toSet());
            HashSet disabledOptions = new HashSet();
            platformHooks.collectDisabledOverrides((disabledOption, modId) -> {
                if (!allOptions.contains(disabledOption)) {
                    LOGGER.warn("Mod {} tried to disabled FerriteCore option {}, which does not exist", (Object)modId, (Object)disabledOption);
                } else {
                    LOGGER.warn("Mod {} disabled FerriteCore option {}", (Object)modId, (Object)disabledOption);
                    disabledOptions.add(disabledOption);
                }
            });
            for (Option option : this.options) {
                if (!disabledOptions.contains(option.getName())) continue;
                option.set($ -> false);
            }
        }
    }

    public static class Option {
        private final String name;
        private final String comment;
        private final boolean defaultValue;
        private final List<Option> dependencies;
        @Nullable
        private Boolean value;

        public Option(String name, String comment, boolean defaultValue, Option ... dependencies) {
            this.name = name;
            this.comment = comment;
            this.defaultValue = defaultValue;
            this.dependencies = Arrays.asList(dependencies);
        }

        public void set(Predicate<String> isEnabled) {
            boolean enabled = isEnabled.test(this.getName());
            if (enabled) {
                for (Option dep : this.dependencies) {
                    if (isEnabled.test(dep.getName())) continue;
                    throw new IllegalStateException(this.getName() + " is enabled in the FerriteCore config, but " + dep.getName() + " is not. This is not supported!");
                }
            }
            this.value = enabled;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean isEnabled() {
            return Objects.requireNonNull(this.value);
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }
    }
}

