/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.neoforge.services;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.neoforge.services.NeoForgeRegisterItemHelper;
import com.natamus.collective_common_neoforge.services.helpers.RegisterBlockHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeRegisterBlockHelper
implements RegisterBlockHelper {
    private static final HashMap<String, DeferredRegister.Blocks> deferredBlockRegisterMap = new HashMap();
    private static final HashMap<Identifier, DeferredBlock<Block>> registeredBlocksWithoutItem = new HashMap();
    private static final HashMap<Identifier, Pair<DeferredBlock<Block>, DeferredItem<Item>>> registeredBlockWithItemPairs = new HashMap();

    @Override
    public <T extends Block> void registerBlockWithoutItem(Object modEventBusObject, Identifier Identifier2, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties, boolean lastBlock) {
        NeoForgeRegisterBlockHelper.staticRegisterBlock(modEventBusObject, Identifier2, blockFunction, properties, null, lastBlock, false);
    }

    @Override
    public Block getRegisteredBlockWithoutItem(Identifier Identifier2) {
        return (Block)registeredBlocksWithoutItem.get(Identifier2).get();
    }

    @Override
    public <T extends Block> void registerBlockWithItem(Object modEventBusObject, Identifier Identifier2, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastBlock) {
        NeoForgeRegisterBlockHelper.staticRegisterBlock(modEventBusObject, Identifier2, blockFunction, properties, creativeModeTabResourceKey, lastBlock, true);
    }

    @Override
    public Block getRegisteredBlockWithItem(Identifier Identifier2) {
        return (Block)((DeferredBlock)registeredBlockWithItemPairs.get(Identifier2).getFirst()).get();
    }

    @Override
    public Pair<Block, BlockItem> getRegisteredBlockWithItemPair(Identifier Identifier2) {
        Pair<DeferredBlock<Block>, DeferredItem<Item>> deferredPair = registeredBlockWithItemPairs.get(Identifier2);
        return Pair.of((Object)((Block)((DeferredBlock)deferredPair.getFirst()).get()), (Object)((BlockItem)((DeferredItem)deferredPair.getSecond()).get()));
    }

    @Override
    public void setRegisteredBlockWithItemPair(Identifier Identifier2, Class<?> blockClass, String blockFieldName, Class<?> blockItemClass, String blockItemFieldName) {
        Pair<DeferredBlock<Block>, DeferredItem<Item>> deferredPair = registeredBlockWithItemPairs.get(Identifier2);
        try {
            Field blockField = blockClass.getDeclaredField(blockFieldName);
            blockField.setAccessible(true);
            blockField.set(null, ((DeferredBlock)deferredPair.getFirst()).get());
            Field blockItemField = blockItemClass.getDeclaredField(blockItemFieldName);
            blockItemField.setAccessible(true);
            blockItemField.set(null, ((DeferredItem)deferredPair.getSecond()).get());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static <T extends Block> void staticRegisterBlock(Object modEventBusObject, Identifier Identifier2, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties, ResourceKey<CreativeModeTab> creativeModeTabResourceKey, boolean lastBlock, boolean registerAsItem) {
        String namespace = Identifier2.getNamespace();
        if (!deferredBlockRegisterMap.containsKey(namespace)) {
            DeferredRegister.Blocks deferredBlockRegister = DeferredRegister.createBlocks((String)namespace);
            deferredBlockRegisterMap.put(namespace, deferredBlockRegister);
        }
        DeferredBlock deferredBlockObject = deferredBlockRegisterMap.get(namespace).registerBlock(Identifier2.getPath(), blockFunction, () -> properties);
        if (registerAsItem) {
            DeferredItem<Item> deferredItemObject = NeoForgeRegisterItemHelper.staticRegisterItem(modEventBusObject, Identifier2, itemProperties -> new BlockItem((Block)deferredBlockObject.get(), itemProperties), new Item.Properties().useBlockDescriptionPrefix(), creativeModeTabResourceKey, lastBlock);
            registeredBlockWithItemPairs.put(Identifier2, (Pair<DeferredBlock<Block>, DeferredItem<Item>>)Pair.of((Object)deferredBlockObject, deferredItemObject));
        } else {
            registeredBlocksWithoutItem.put(Identifier2, (DeferredBlock<Block>)deferredBlockObject);
        }
        if (lastBlock) {
            deferredBlockRegisterMap.get(namespace).register((IEventBus)modEventBusObject);
        }
    }
}

