/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.jdbc;

import java.sql.DatabaseMetaData;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.IdentifierManagerApi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000f\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000e8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0010\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u000e8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\u00020\u000e8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u000e8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0011R\u001a\u0010\u0017\u001a\u00020\u000e8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0011R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u00078\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000b\u001a\u0004\b\u001c\u0010\rR \u0010\u001e\u001a\u00020\u001d8\u0014X\u0094\u0004\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u0012\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u001a\u0010%\u001a\u00020$8\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/statements/jdbc/JdbcIdentifierManager;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi;", "Ljava/sql/DatabaseMetaData;", "metadata", "<init>", "(Ljava/sql/DatabaseMetaData;)V", "", "", "dbKeywords", "()Ljava/util/List;", "quoteString", "Ljava/lang/String;", "getQuoteString", "()Ljava/lang/String;", "", "isUpperCaseIdentifiers", "Z", "()Z", "isUpperCaseQuotedIdentifiers", "isLowerCaseIdentifiers", "isLowerCaseQuotedIdentifiers", "supportsMixedIdentifiers", "getSupportsMixedIdentifiers", "supportsMixedQuotedIdentifiers", "getSupportsMixedQuotedIdentifiers", "_keywords", "Ljava/util/List;", "extraNameCharacters", "getExtraNameCharacters", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi$OracleVersion;", "oracleVersion", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi$OracleVersion;", "getOracleVersion", "()Lorg/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi$OracleVersion;", "getOracleVersion$annotations", "()V", "", "maxColumnNameLength", "I", "getMaxColumnNameLength", "()I", "exposed-jdbc"})
public final class JdbcIdentifierManager
extends IdentifierManagerApi {
    @NotNull
    private final String quoteString;
    private final boolean isUpperCaseIdentifiers;
    private final boolean isUpperCaseQuotedIdentifiers;
    private final boolean isLowerCaseIdentifiers;
    private final boolean isLowerCaseQuotedIdentifiers;
    private final boolean supportsMixedIdentifiers;
    private final boolean supportsMixedQuotedIdentifiers;
    @NotNull
    private final List<String> _keywords;
    @NotNull
    private final String extraNameCharacters;
    @NotNull
    private final IdentifierManagerApi.OracleVersion oracleVersion;
    private final int maxColumnNameLength;

    public JdbcIdentifierManager(@NotNull DatabaseMetaData metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        String string = metadata.getIdentifierQuoteString();
        Intrinsics.checkNotNull((Object)string);
        this.quoteString = ((Object)StringsKt.trim((CharSequence)string)).toString();
        this.isUpperCaseIdentifiers = metadata.storesUpperCaseIdentifiers();
        this.isUpperCaseQuotedIdentifiers = metadata.storesUpperCaseQuotedIdentifiers();
        this.isLowerCaseIdentifiers = metadata.storesLowerCaseIdentifiers();
        this.isLowerCaseQuotedIdentifiers = metadata.storesLowerCaseQuotedIdentifiers();
        this.supportsMixedIdentifiers = metadata.supportsMixedCaseIdentifiers();
        this.supportsMixedQuotedIdentifiers = metadata.supportsMixedCaseQuotedIdentifiers();
        String string2 = metadata.getSQLKeywords();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSQLKeywords(...)");
        char[] cArray = new char[]{','};
        this._keywords = StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String string3 = metadata.getExtraNameCharacters();
        Intrinsics.checkNotNull((Object)string3);
        this.extraNameCharacters = string3;
        this.oracleVersion = !Intrinsics.areEqual((Object)metadata.getDatabaseProductName(), (Object)"Oracle") ? IdentifierManagerApi.OracleVersion.NonOracle : (metadata.getDatabaseMajorVersion() <= 11 ? IdentifierManagerApi.OracleVersion.Oracle11g : (metadata.getDatabaseMajorVersion() == 12 && metadata.getDatabaseMinorVersion() == 1 ? IdentifierManagerApi.OracleVersion.Oracle12_1g : IdentifierManagerApi.OracleVersion.Oracle12plus));
        this.maxColumnNameLength = metadata.getMaxColumnNameLength();
    }

    @Override
    @NotNull
    public String getQuoteString() {
        return this.quoteString;
    }

    @Override
    protected boolean isUpperCaseIdentifiers() {
        return this.isUpperCaseIdentifiers;
    }

    @Override
    protected boolean isUpperCaseQuotedIdentifiers() {
        return this.isUpperCaseQuotedIdentifiers;
    }

    @Override
    protected boolean isLowerCaseIdentifiers() {
        return this.isLowerCaseIdentifiers;
    }

    @Override
    protected boolean isLowerCaseQuotedIdentifiers() {
        return this.isLowerCaseQuotedIdentifiers;
    }

    @Override
    protected boolean getSupportsMixedIdentifiers() {
        return this.supportsMixedIdentifiers;
    }

    @Override
    protected boolean getSupportsMixedQuotedIdentifiers() {
        return this.supportsMixedQuotedIdentifiers;
    }

    @Override
    @NotNull
    protected List<String> dbKeywords() {
        return this._keywords;
    }

    @Override
    @NotNull
    protected String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    @Override
    @NotNull
    protected IdentifierManagerApi.OracleVersion getOracleVersion() {
        return this.oracleVersion;
    }

    protected static /* synthetic */ void getOracleVersion$annotations() {
    }

    @Override
    protected int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }
}

