/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.other;

import eu.pb4.graves.config.ConfigManager;
import net.minecraft.class_3222;

public enum GravesXPCalculation {
    NONE("none", p -> 0),
    VANILLA("vanilla", p -> Math.min(p.field_7520 * 7, 100)),
    DROP("drop", p -> Math.min(p.field_7520 * 7, 100)),
    PERCENT_POINTS("percent_points", p -> {
        int points = 0;
        for (int i = 0; i < p.field_7520; ++i) {
            if (i >= 30) {
                points += 112 + (i - 30) * 9;
                continue;
            }
            points += i >= 15 ? 37 + (i - 15) * 5 : 7 + i * 2;
        }
        points = (int)((float)points + p.field_7510 * (float)p.method_7349());
        return (int)((double)points * ConfigManager.getConfig().storage.xpPercentTypeValue / 100.0);
    }),
    PERCENT_LEVELS("percent_levels", p -> {
        int points = 0;
        double percent = ConfigManager.getConfig().storage.xpPercentTypeValue / 100.0;
        int i = 0;
        while ((double)i < (double)p.field_7520 * percent) {
            points = i >= 30 ? (points += 112 + (i - 30) * 9) : (points += i >= 15 ? 37 + (i - 15) * 5 : 7 + i * 2);
            ++i;
        }
        points = (int)((double)points + (double)(p.field_7510 * (float)p.method_7349()) * percent);
        return points;
    });

    public final String name;
    public final Player2XP converter;

    private GravesXPCalculation(String name, Player2XP converter) {
        this.name = name;
        this.converter = converter;
    }

    public String configName() {
        return this.name;
    }

    public static GravesXPCalculation byName(String name) {
        for (GravesXPCalculation type : GravesXPCalculation.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return NONE;
    }

    public static String next(String xpStorageType) {
        GravesXPCalculation byName = GravesXPCalculation.byName(xpStorageType);
        return GravesXPCalculation.values()[(byName.ordinal() + 1) % GravesXPCalculation.values().length].name;
    }

    @FunctionalInterface
    public static interface Player2XP {
        public int calc(class_3222 var1);
    }
}

