/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.enginehub.linbus.tree.LinCompoundTag;

public class BlockState
implements BlockStateHolder<BlockState> {
    private final BlockType blockType;
    private final Map<Property<?>, Object> values;
    private final int stateListIndex;
    private final BaseBlock emptyBaseBlock;
    private final LazyReference<String> lazyStringRepresentation;
    private volatile int internalId = BlockStateIdAccess.invalidId();
    private Integer hashCodeCache = null;

    BlockState(BlockType blockType, Map<Property<?>, Object> values, int stateListIndex) {
        this.blockType = blockType;
        this.values = values;
        this.stateListIndex = stateListIndex;
        this.emptyBaseBlock = new BaseBlock(this);
        this.lazyStringRepresentation = LazyReference.from(() -> BlockStateHolder.super.getAsString());
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public <V> BlockState with(Property<V> property, V value) {
        if (this.stateListIndex == -1) {
            return this;
        }
        Object currentValue = this.values.get(property);
        if (Objects.equals(currentValue, value)) {
            return this;
        }
        int newIndex = this.blockType.getInternalStateList().updateIndexOrInvalid(this.stateListIndex, property, currentValue, value);
        if (newIndex == -1) {
            return this;
        }
        return (BlockState)this.blockType.getInternalStateList().get(newIndex);
    }

    @Override
    public <V> V getState(Property<V> property) {
        return (V)this.values.get(property);
    }

    @Override
    public Map<Property<?>, Object> getStates() {
        return this.values;
    }

    @Override
    public boolean equalsFuzzy(BlockStateHolder<?> o) {
        if (null == o) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!this.blockType.equals(o.getBlockType())) {
            return false;
        }
        HashSet differingProperties = new HashSet();
        for (Property<?> state : o.getStates().keySet()) {
            if (this.getState(state) != null) continue;
            differingProperties.add(state);
        }
        for (Property<?> property : this.values.keySet()) {
            if (o.getState(property) != null) continue;
            differingProperties.add(property);
        }
        for (Property<?> property : this.values.keySet()) {
            if (differingProperties.contains(property) || Objects.equals(this.getState(property), o.getState(property))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockState toImmutableState() {
        return this;
    }

    @Override
    public BaseBlock toBaseBlock() {
        return this.emptyBaseBlock;
    }

    @Override
    public BaseBlock toBaseBlock(LazyReference<LinCompoundTag> compoundTag) {
        if (compoundTag == null) {
            return this.toBaseBlock();
        }
        return new BaseBlock(this, compoundTag);
    }

    @Override
    public String getAsString() {
        return this.lazyStringRepresentation.getValue();
    }

    public String toString() {
        return this.getAsString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockState)) {
            return false;
        }
        BlockState blockState = (BlockState)obj;
        return this.equalsFuzzy(blockState);
    }

    public int hashCode() {
        if (this.hashCodeCache == null) {
            this.hashCodeCache = Objects.hash(this.blockType, this.values);
        }
        return this.hashCodeCache;
    }

    static {
        BlockStateIdAccess.setBlockStateInternalId(new BlockStateIdAccess.BlockStateInternalId(){

            @Override
            public int getInternalId(BlockState blockState) {
                return blockState.internalId;
            }

            @Override
            public void setInternalId(BlockState blockState, int internalId) {
                blockState.internalId = internalId;
            }
        });
    }
}

