/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.packager;

import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.logistics.packager.AllInventoryIdentifiers;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_3341;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface InventoryIdentifier {
    public static final SimpleRegistry<class_2248, Finder> REGISTRY = SimpleRegistry.create();

    public boolean contains(BlockFace var1);

    @Nullable
    public static InventoryIdentifier get(class_1937 level, BlockFace face) {
        class_2680 state = level.method_8320(face.getPos());
        Finder finder = REGISTRY.get((class_2688<class_2248, ?>)state);
        Finder toQuery = finder != null ? finder : AllInventoryIdentifiers::fallback;
        return toQuery.find(level, state, face);
    }

    @FunctionalInterface
    public static interface Finder {
        @Nullable
        public InventoryIdentifier find(class_1937 var1, class_2680 var2, BlockFace var3);
    }

    public record MultiFace(class_2338 pos, Set<class_2350> sides) implements InventoryIdentifier
    {
        @Override
        public boolean contains(BlockFace face) {
            return this.pos.equals((Object)face.getPos()) && this.sides.contains(face.getFace());
        }
    }

    public record Bounds(class_3341 bounds) implements InventoryIdentifier
    {
        @Override
        public boolean contains(BlockFace face) {
            return this.bounds.method_14662((class_2382)face.getPos());
        }
    }

    public record Pair(class_2338 first, class_2338 second) implements InventoryIdentifier
    {
        public Pair(class_2338 first, class_2338 second) {
            if (first.method_10265((class_2382)second) < 0) {
                this.first = first;
                this.second = second;
            } else {
                this.first = second;
                this.second = first;
            }
        }

        @Override
        public boolean contains(BlockFace face) {
            class_2338 pos = face.getPos();
            return this.first.equals((Object)pos) || this.second.equals((Object)pos);
        }
    }

    public record Single(class_2338 pos) implements InventoryIdentifier
    {
        @Override
        public boolean contains(BlockFace face) {
            return this.pos.equals((Object)face.getPos());
        }
    }
}

