/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.registry;

import com.zurrtum.create.impl.registry.SimpleRegistryImpl;
import com.zurrtum.create.impl.registry.TagProviderImpl;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2688;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface SimpleRegistry<K, V> {
    public static <K, V> SimpleRegistry<K, V> create() {
        return SimpleRegistryImpl.single();
    }

    public void register(K var1, V var2);

    public void registerProvider(Provider<K, V> var1);

    public void invalidate();

    @Nullable
    default public V get(K object, class_1937 world) {
        return this.get(object);
    }

    @Nullable
    public V get(K var1);

    @Nullable
    public V get(class_2688<K, ?> var1);

    public static interface Multi<K, V>
    extends SimpleRegistry<K, List<V>> {
        public static <K, V> Multi<K, V> create() {
            return SimpleRegistryImpl.multi();
        }

        public void add(K var1, V var2);

        public void addProvider(Provider<K, V> var1);

        @Override
        @NotNull
        public List<V> get(K var1);

        @Override
        @NotNull
        public List<V> get(K var1, class_1937 var2);

        @Override
        @NotNull
        public List<V> get(class_2688<K, ?> var1);
    }

    @FunctionalInterface
    public static interface Provider<K, V> {
        public static <K, V> Provider<K, V> forTag(class_6862<K> tag, Function<K, class_6880<K>> holderGetter, V value) {
            return new TagProviderImpl<K, V>(tag, holderGetter, value);
        }

        public static <V> Provider<class_2248, V> forBlockTag(class_6862<class_2248> tag, V value) {
            return new TagProviderImpl<class_2248, V>(tag, class_2248::method_40142, value);
        }

        public static <V> Provider<class_2591<?>, V> forBlockEntityTag(class_6862<class_2591<?>> tag, V value) {
            return new TagProviderImpl<class_2591, V>(tag, TagProviderImpl::getBeHolder, value);
        }

        public static <V> Provider<class_1792, V> forItemTag(class_6862<class_1792> tag, V value) {
            return new TagProviderImpl<class_1792, V>(tag, class_1792::method_40131, value);
        }

        public static <V> Provider<class_1299<?>, V> forEntityTag(class_6862<class_1299<?>> tag, V value) {
            return new TagProviderImpl<class_1299, V>(tag, class_1299::method_40124, value);
        }

        public static <V> Provider<class_3611, V> forFluidTag(class_6862<class_3611> tag, V value) {
            return new TagProviderImpl<class_3611, V>(tag, class_3611::method_40178, value);
        }

        @Nullable
        default public V get(K object, class_1937 world) {
            return this.get(object);
        }

        @Nullable
        public V get(K var1);

        default public void onRegister(Runnable invalidate) {
        }
    }
}

