/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.SawRenderState;
import com.zurrtum.create.compat.eiv.display.BlockCuttingDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class BlockCuttingView
extends CreateView {
    private final SlotContent ingredient;
    private final List<SlotContent> results;

    public BlockCuttingView(BlockCuttingDisplay display) {
        this.ingredient = SlotContent.of(display.ingredient);
        this.results = display.results.stream().map(SlotContent::of).toList();
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.BLOCK_CUTTING;
    }

    public List<SlotContent> getIngredients() {
        return List.of(this.ingredient);
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    @Override
    protected int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        slotDefinition.addItemSlot(0, 3, 1);
        int size = this.results.size();
        int left = 76;
        int top = 44;
        for (int i = 0; i < size; ++i) {
            slotDefinition.addItemSlot(i + 1, left + i % 5 * 19, top + i / 5 * -19);
        }
        return size + 1;
    }

    @Override
    protected int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindOptionalSlot(0, this.ingredient, SLOT);
        int size = this.results.size();
        for (int i = 0; i < size; ++i) {
            slotFillContext.bindOptionalSlot(i + 1, this.results.get(i), SLOT);
        }
        return size + 1;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 29, 2);
        AllGuiTextures.JEI_SHADOW.render(context, 14, 46);
        context.field_59826.method_70922((class_11256)new SawRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 23, 22));
    }
}

