/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.jei;

import com.zurrtum.create.client.content.logistics.stockTicker.CraftableBigItemStack;
import com.zurrtum.create.client.content.logistics.stockTicker.CraftableInput;
import com.zurrtum.create.client.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import mezz.jei.library.transfer.RecipeTransferErrorTooltip;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class StockKeeperTransferHandler
implements IUniversalRecipeTransferHandler<StockKeeperRequestMenu> {
    public Class<? extends StockKeeperRequestMenu> getContainerClass() {
        return StockKeeperRequestMenu.class;
    }

    public Optional<class_3917<StockKeeperRequestMenu>> getMenuType() {
        return Optional.empty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public IRecipeTransferError transferRecipe(StockKeeperRequestMenu container, Object object, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (!(object instanceof class_8786)) {
            return null;
        }
        class_8786 entry = (class_8786)object;
        Object object2 = container.screenReference;
        if (!(object2 instanceof StockKeeperRequestScreen)) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        StockKeeperRequestScreen screen = (StockKeeperRequestScreen)((Object)object2);
        class_2960 id = entry.comp_1932().method_29177();
        for (CraftableBigItemStack cbis : screen.recipesToOrder) {
            if (!cbis.id.equals((Object)id)) continue;
            return new RecipeTransferErrorTooltip((class_2561)CreateLang.translateDirect("gui.stock_keeper.already_ordering_recipe", new Object[0]));
        }
        if (screen.itemsToOrder.size() >= 9) {
            return new RecipeTransferErrorTooltip((class_2561)CreateLang.translateDirect("gui.stock_keeper.slots_full", new Object[0]));
        }
        ArrayList<IRecipeSlotView> inputViews = new ArrayList<IRecipeSlotView>();
        ArrayList<IRecipeSlotView> outputViews = new ArrayList<IRecipeSlotView>();
        for (IRecipeSlotView view : recipeSlots.getSlotViews()) {
            RecipeIngredientRole role = view.getRole();
            if (role == RecipeIngredientRole.INPUT) {
                inputViews.add(view);
                continue;
            }
            if (role != RecipeIngredientRole.OUTPUT) continue;
            outputViews.add(view);
        }
        CraftableInput inputs = CraftableInput.create(entry.comp_1933() instanceof class_3955);
        int size = inputViews.size();
        for (int i = 0; i < size; ++i) {
            @Nullable List list = ((IRecipeSlotView)inputViews.get(i)).getAllIngredientsList();
            if (list.isEmpty()) continue;
            ArrayList<class_1799> items = new ArrayList<class_1799>(size);
            for (ITypedIngredient ingredient : list) {
                if (ingredient == null) continue;
                Optional value = ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK);
                if (value.isEmpty()) {
                    return RecipeTransferErrorInternal.INSTANCE;
                }
                items.add((class_1799)value.get());
            }
            inputs.add(items, i);
        }
        if (inputs.data().size() > 9) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        class_1799 output = null;
        for (IRecipeSlotView view : outputViews) {
            Optional stack = view.getDisplayedItemStack();
            if (!stack.isPresent()) continue;
            output = (class_1799)stack.get();
            break;
        }
        if (output == null) {
            return new RecipeTransferErrorMissingSlots((class_2561)CreateLang.translateDirect("gui.stock_keeper.recipe_result_empty", new Object[0]), outputViews);
        }
        InventorySummary summary = ((StockTickerBlockEntity)((StockKeeperRequestMenu)screen.method_17577()).contentHolder).getLastClientsideStockSnapshotAsSummary();
        if (summary == null) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        IntSet missingIndices = inputs.getMissing(summary.getStacksByCount());
        if (!missingIndices.isEmpty()) {
            ArrayList missingViews = new ArrayList();
            missingIndices.forEach(index -> missingViews.add((IRecipeSlotView)inputViews.get(index)));
            return new RecipeTransferErrorMissingSlots((class_2561)CreateLang.translateDirect("gui.stock_keeper.not_in_stock", new Object[0]), missingViews);
        }
        if (doTransfer) {
            CraftableBigItemStack cbis = new CraftableBigItemStack(id, inputs, output);
            screen.recipesToOrder.add(cbis);
            screen.searchBox.method_1852("");
            screen.refreshSearchNextTick = true;
            screen.requestCraftable(cbis, maxTransfer ? cbis.stack.method_7914() : 1);
        }
        return null;
    }
}

