/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.saw;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.saw.SawActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class SawMovementRenderBehaviour
implements MovementRenderBehaviour {
    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new SawActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(class_243 camera, class_327 textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        SawMovementRenderState state = new SawMovementRenderState(context.localPos);
        class_2680 blockState = context.state;
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)SawBlock.FACING);
        class_243 facingVec = class_243.method_24954((class_2382)facing.method_62675());
        facingVec = (class_243)context.rotation.apply(facingVec);
        class_2350 closestToFacing = class_2350.method_10142((double)facingVec.field_1352, (double)facingVec.field_1351, (double)facingVec.field_1350);
        boolean horizontal = closestToFacing.method_10166().method_10179();
        boolean backwards = VecHelper.isVecPointingTowards(context.relativeMotion, facing.method_10153());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        state.layer = class_12249.method_75972();
        if (SawBlock.isHorizontal(blockState)) {
            state.saw = CachedBuffers.partial(shouldAnimate ? AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE : AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE, blockState);
        } else {
            state.saw = CachedBuffers.partial(shouldAnimate ? AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE : AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE, blockState);
            if (((Boolean)blockState.method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                state.zRot = 1.5707964f;
            }
        }
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.xRot = (float)Math.PI / 180 * AngleHelper.verticalAngle(facing);
        state.light = class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        if (!VisualizationManager.supportsVisualization((class_1936)context.world)) {
            class_2350.class_2351 axis = facing.method_10166();
            if (axis.method_10179()) {
                state.shaft = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, blockState.method_26204().method_9598(blockState, class_2470.field_11464));
            } else {
                boolean alongFirst = (Boolean)blockState.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
                if (axis == class_2350.class_2351.field_11048) {
                    axis = alongFirst ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051;
                } else if (axis == class_2350.class_2351.field_11052) {
                    axis = alongFirst ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
                } else if (axis == class_2350.class_2351.field_11051) {
                    axis = alongFirst ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11052;
                }
                state.shaft = CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, KineticBlockEntityRenderer.shaft(axis));
            }
            state.angle = (float)Math.PI / 180 * KineticBlockEntityVisual.rotationOffset(blockState, axis, (class_2382)context.localPos);
            state.direction = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
        }
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    public static class SawMovementRenderState
    extends MovementRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public class_1937 world;
        public SuperByteBuffer saw;
        public Matrix4f worldMatrix4f;
        public float yRot;
        public float xRot;
        public float zRot;
        public int light;
        public SuperByteBuffer shaft;
        public float angle;
        public class_2350 direction;

        public SawMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, this.layer, (class_11659.class_11660)this);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.saw.center()).rotateY(this.yRot)).rotateX(this.xRot)).rotateZ(this.zRot)).uncenter()).light(this.light).useLevelLight((class_1920)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            if (this.shaft != null) {
                ((SuperByteBuffer)this.shaft.light(this.light).useLevelLight((class_1920)this.world, this.worldMatrix4f).rotateCentered(this.angle, this.direction)).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

