/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.saw;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class SawRenderer
implements class_827<SawBlockEntity, SawRenderState> {
    protected final class_10442 itemModelManager;

    public SawRenderer(class_5614.class_5615 context) {
        this.itemModelManager = context.comp_4536();
    }

    public SawRenderState createRenderState() {
        return new SawRenderState();
    }

    public void extractRenderState(SawBlockEntity be, SawRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        state.layer = class_12249.method_75972();
        state.partialTicks = tickProgress;
        state.speed = be.getSpeed();
        this.updateBlade(state);
        class_1937 world = be.method_10997();
        this.updateItems(be.inventory, world, state);
        if (!be.method_11015()) {
            state.filter = FilteringRenderer.getFilterRenderState(be, state.field_62674, this.itemModelManager, be.isVirtual() ? -1.0 : cameraPos.method_1025(VecHelper.getCenterOf((class_2382)state.field_62673)));
        }
        if (VisualizationManager.supportsVisualization((class_1936)world)) {
            return;
        }
        class_2350.class_2351 axis = ((IRotate)state.field_62674.method_26204()).getRotationAxis(state.field_62674);
        state.shaft = this.getRotatedModel(state.field_62674, axis);
        state.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.field_62673, axis);
        state.direction = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
        state.color = KineticBlockEntityRenderer.getColor(be);
    }

    public void submit(SawRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
        if (state.items != null) {
            this.renderItems(state, matrices, queue);
        }
        if (state.filter != null) {
            state.filter.render(state.field_62674, queue, matrices, state.field_62676);
        }
    }

    public void updateBlade(SawRenderState state) {
        PartialModel partial;
        class_2680 blockState = state.field_62674;
        float speed = state.speed;
        boolean rotate = false;
        if (SawBlock.isHorizontal(blockState)) {
            partial = speed > 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_REVERSED : AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE);
        } else {
            partial = speed > 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_REVERSED : AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE);
            if (((Boolean)blockState.method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                rotate = true;
            }
        }
        state.blade = CachedBuffers.partialFacing(partial, blockState);
        state.bladeAngle = rotate ? AngleHelper.rad(90.0) : -1.0f;
    }

    public void updateItems(ProcessingInventory inventory, class_1937 world, SawRenderState state) {
        boolean hasInput;
        if (state.field_62674.method_11654((class_2769)SawBlock.FACING) != class_2350.field_11036) {
            return;
        }
        ArrayList<class_10444> items = new ArrayList<class_10444>();
        BooleanArrayList box = new BooleanArrayList();
        class_1799 stack = inventory.method_5438(0);
        boolean bl = hasInput = !stack.method_7960();
        if (hasInput) {
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4319;
            this.itemModelManager.method_65596(renderState, stack, class_811.field_4319, world, null, 0);
            items.add(renderState);
            box.add(PackageItem.isPackage(stack));
        }
        int size = inventory.method_5439();
        for (int i = 1; i < size; ++i) {
            stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4319;
            this.itemModelManager.method_65596(renderState, stack, class_811.field_4319, world, null, 0);
            items.add(renderState);
            box.add(PackageItem.isPackage(stack));
        }
        if (items.isEmpty()) {
            return;
        }
        state.items = items;
        state.box = box;
        state.outputs = hasInput ? items.size() - 1 : items.size();
        state.alongZ = (Boolean)state.field_62674.method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        state.duration = inventory.recipeDuration;
        state.remainingTime = inventory.remainingTime;
        state.appliedRecipe = inventory.appliedRecipe;
    }

    public void renderItems(SawRenderState state, class_4587 ms, class_11659 queue) {
        float offset;
        boolean alongZ = state.alongZ;
        float duration = state.duration;
        float speed = state.speed;
        boolean moving = duration != 0.0f;
        float f = offset = moving ? state.remainingTime / duration : 0.0f;
        if (moving) {
            float processingSpeed = class_3532.method_15363((float)(Math.abs(speed) / 32.0f), (float)1.0f, (float)128.0f);
            offset = class_3532.method_15363((float)(offset + (-state.partialTicks + 0.5f) * processingSpeed / duration), (float)0.125f, (float)1.0f);
            if (!state.appliedRecipe) {
                offset += 1.0f;
            }
            offset /= 2.0f;
        }
        if (speed == 0.0f) {
            offset = 0.5f;
        }
        if (speed < 0.0f ^ alongZ) {
            offset = 1.0f - offset;
        }
        int outputs = state.outputs;
        ms.method_22903();
        if (alongZ) {
            ms.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        }
        ms.method_22904(outputs <= 1 ? 0.5 : 0.25, 0.0, (double)offset);
        ms.method_46416(alongZ ? -1.0f : 0.0f, 0.0f, 0.0f);
        int renderedI = 0;
        List<class_10444> items = state.items;
        BooleanList boxList = state.box;
        int light = state.field_62676;
        int size = items.size();
        PoseTransformStack msr = size > 1 && outputs > 1 ? TransformStack.of(ms) : null;
        for (int i = 0; i < size; ++i) {
            boolean box;
            class_10444 renderState = items.get(i);
            ms.method_22903();
            ms.method_46416(0.0f, renderState.method_65608() ? 0.925f : 0.8125f, 0.0f);
            if (i > 0 && outputs > 1) {
                ms.method_22904(0.5 / (double)(outputs - 1) * (double)renderedI, 0.0, 0.0);
                msr.nudge(i * 133);
            }
            if (box = boxList.getBoolean(i)) {
                ms.method_46416(0.0f, 0.25f, 0.0f);
                ms.method_22905(1.5f, 1.5f, 1.5f);
            } else {
                ms.method_22905(0.5f, 0.5f, 0.5f);
            }
            if (!box) {
                ms.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
            }
            renderState.method_65604(ms, queue, light, class_4608.field_21444, 0);
            ++renderedI;
            ms.method_22909();
        }
        ms.method_22909();
    }

    protected SuperByteBuffer getRotatedModel(class_2680 state, class_2350.class_2351 axis) {
        if (((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10166().method_10179()) {
            return CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.method_26204().method_9598(state, class_2470.field_11464));
        }
        return CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, KineticBlockEntityRenderer.shaft(axis));
    }

    @Environment(value=EnvType.CLIENT)
    public static class SawRenderState
    extends class_11954
    implements class_11659.class_11660 {
        public class_1921 layer;
        public float speed;
        public float partialTicks;
        public SuperByteBuffer blade;
        public float bladeAngle;
        public List<class_10444> items;
        public BooleanList box;
        public int outputs;
        public boolean alongZ;
        public float duration;
        public float remainingTime;
        public boolean appliedRecipe;
        public FilteringRenderer.FilterRenderState filter;
        public SuperByteBuffer shaft;
        public float angle;
        public class_2350 direction;
        public Color color;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (this.bladeAngle != -1.0f) {
                this.blade.rotateCentered(this.bladeAngle, class_2350.field_11036);
            }
            this.blade.color(0xFFFFFF).light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
            if (this.shaft != null) {
                ((SuperByteBuffer)this.shaft.light(this.field_62676).rotateCentered(this.angle, this.direction)).color(this.color).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

