/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.textures.GpuTexture;
import com.zurrtum.create.client.flywheel.backend.compile.IndirectPrograms;
import com.zurrtum.create.client.flywheel.backend.gl.GlTextureUnit;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10868;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL46;

@Environment(value=EnvType.CLIENT)
public class DepthPyramid {
    private final IndirectPrograms programs;
    public int pyramidTextureId = -1;
    private int lastWidth = -1;
    private int lastHeight = -1;

    public DepthPyramid(IndirectPrograms programs) {
        this.programs = programs;
    }

    public void generate() {
        class_276 mainRenderTarget = class_310.method_1551().method_1522();
        int width = DepthPyramid.mip0Size(mainRenderTarget.field_1482);
        int height = DepthPyramid.mip0Size(mainRenderTarget.field_1481);
        int mipLevels = DepthPyramid.getImageMipLevels(width, height);
        this.createPyramidMips(mipLevels, width, height);
        GpuTexture depthTexture = mainRenderTarget.method_30278();
        int depthBufferId = depthTexture != null ? ((class_10868)depthTexture).method_68427() : 0;
        GL46.glMemoryBarrier((int)1024);
        GlTextureUnit.T0.makeActive();
        GlStateManager._bindTexture((int)depthBufferId);
        GlProgram downsampleFirstProgram = this.programs.getDownsampleFirstProgram();
        downsampleFirstProgram.bind();
        GL46.glBindImageTexture((int)1, (int)this.pyramidTextureId, (int)0, (boolean)false, (int)0, (int)35001, (int)33326);
        GL46.glDispatchCompute((int)MoreMath.ceilingDiv(width << 1, 64), (int)MoreMath.ceilingDiv(height << 1, 64), (int)1);
        GlProgram downsampleSecondProgram = this.programs.getDownsampleSecondProgram();
        downsampleSecondProgram.bind();
        downsampleSecondProgram.setUInt("mip_levels", mipLevels);
        int baseMipLevel = 0;
        while (baseMipLevel + 1 < mipLevels) {
            GL46.glMemoryBarrier((int)32);
            downsampleSecondProgram.setUInt("base_mip_level", baseMipLevel);
            for (int i = 0; i < Math.min(7, mipLevels - baseMipLevel); ++i) {
                GL46.glBindImageTexture((int)i, (int)this.pyramidTextureId, (int)(baseMipLevel + i), (boolean)false, (int)0, (int)35001, (int)33326);
            }
            GL46.glDispatchCompute((int)MoreMath.ceilingDiv(width >> baseMipLevel, 64), (int)MoreMath.ceilingDiv(height >> baseMipLevel, 64), (int)1);
            baseMipLevel += 6;
        }
        GL46.glMemoryBarrier((int)8);
    }

    public void bindForCull() {
        GlTextureUnit.T0.makeActive();
        GlStateManager._bindTexture((int)this.pyramidTextureId);
    }

    public void delete() {
        if (this.pyramidTextureId != -1) {
            GL32.glDeleteTextures((int)this.pyramidTextureId);
            this.pyramidTextureId = -1;
        }
    }

    private void createPyramidMips(int mipLevels, int width, int height) {
        if (this.lastWidth == width && this.lastHeight == height) {
            return;
        }
        this.lastWidth = width;
        this.lastHeight = height;
        this.delete();
        this.pyramidTextureId = GL46.glCreateTextures((int)3553);
        GL46.glTextureStorage2D((int)this.pyramidTextureId, (int)mipLevels, (int)33326, (int)width, (int)height);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)10241, (int)9728);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)10240, (int)9728);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)34892, (int)0);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)10242, (int)33071);
        GL46.glTextureParameteri((int)this.pyramidTextureId, (int)10243, (int)33071);
    }

    public static int mipSize(int mip0Size, int level) {
        return Math.max(1, mip0Size >> level);
    }

    public static int mip0Size(int screenSize) {
        return Integer.highestOneBit(screenSize);
    }

    public static int getImageMipLevels(int width, int height) {
        int result = 1;
        while (width > 1 && height > 1) {
            ++result;
            width >>= 1;
            height >>= 1;
        }
        return result;
    }
}

