/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.uniform;

import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformBuffer;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformWriter;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_12131;
import net.minecraft.class_12202;
import net.minecraft.class_12206;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_308;
import net.minecraft.class_4184;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public final class LevelUniforms
extends UniformWriter {
    private static final int SIZE = 112;
    static final UniformBuffer BUFFER = new UniformBuffer(4, 112);
    static final Map<class_308.class_11274, float[]> CACHE = new EnumMap<class_308.class_11274, float[]>(class_308.class_11274.class);
    public static float[] LIGHT_DIRECTION;

    private LevelUniforms() {
    }

    public static void update(class_308.class_11274 type, Vector3f light0Diffusion, Vector3f light1Diffusion) {
        float[] diffusions = CACHE.computeIfAbsent(type, t -> new float[6]);
        diffusions[0] = light0Diffusion.x;
        diffusions[1] = light0Diffusion.y;
        diffusions[2] = light0Diffusion.z;
        diffusions[3] = light1Diffusion.x;
        diffusions[4] = light1Diffusion.y;
        diffusions[5] = light1Diffusion.z;
    }

    public static void set(class_308.class_11274 type) {
        LIGHT_DIRECTION = CACHE.computeIfAbsent(type, t -> new float[6]);
    }

    public static void update(RenderContext context) {
        long ptr = BUFFER.ptr();
        class_638 level = context.level();
        float partialTick = context.partialTick();
        class_4184 camera = context.camera();
        class_12202 attributeProbe = camera.method_75756();
        int skyColor = (Integer)attributeProbe.method_75689(class_12206.field_63746, partialTick);
        int cloudColor = (Integer)camera.method_75756().method_75689(class_12206.field_64126, partialTick);
        ptr = LevelUniforms.writeVec4(ptr, class_9848.method_65101((int)skyColor), class_9848.method_65102((int)skyColor), class_9848.method_65103((int)skyColor), 1.0f);
        ptr = LevelUniforms.writeVec4(ptr, class_9848.method_65101((int)cloudColor), class_9848.method_65102((int)cloudColor), class_9848.method_65103((int)cloudColor), 1.0f);
        ptr = LevelUniforms.writeVec3(ptr, LIGHT_DIRECTION[0], LIGHT_DIRECTION[1], LIGHT_DIRECTION[2]);
        ptr = LevelUniforms.writeVec3(ptr, LIGHT_DIRECTION[3], LIGHT_DIRECTION[4], LIGHT_DIRECTION[5]);
        long dayTime = level.method_8532();
        long levelDay = dayTime / 24000L;
        float timeOfDay = (float)(dayTime - levelDay * 24000L) / 24000.0f;
        ptr = LevelUniforms.writeInt(ptr, (int)(levelDay % Integer.MAX_VALUE));
        ptr = LevelUniforms.writeFloat(ptr, timeOfDay);
        ptr = LevelUniforms.writeInt(ptr, level.method_8597().comp_642() ? 1 : 0);
        ptr = LevelUniforms.writeFloat(ptr, ((Float)attributeProbe.method_75689(class_12206.field_64340, partialTick)).floatValue() * ((float)Math.PI / 180));
        class_12131 moonPhase = (class_12131)attributeProbe.method_75689(class_12206.field_64343, partialTick);
        ptr = LevelUniforms.writeFloat(ptr, class_2874.field_24752[moonPhase.method_75261()]);
        ptr = LevelUniforms.writeInt(ptr, moonPhase.method_75261());
        ptr = LevelUniforms.writeInt(ptr, level.method_8419() ? 1 : 0);
        ptr = LevelUniforms.writeFloat(ptr, level.method_8430(partialTick));
        ptr = LevelUniforms.writeInt(ptr, level.method_8546() ? 1 : 0);
        ptr = LevelUniforms.writeFloat(ptr, level.method_8478(partialTick));
        ptr = LevelUniforms.writeFloat(ptr, level.method_8594());
        ptr = LevelUniforms.writeInt(ptr, level.method_8597().comp_5221() == class_2874.class_12325.field_64381 ? 1 : 0);
        class_5321 dimension = level.method_27983();
        int dimensionId = class_1937.field_25179.equals(dimension) ? 0 : (class_1937.field_25180.equals(dimension) ? 1 : (class_1937.field_25181.equals(dimension) ? 2 : -1));
        ptr = LevelUniforms.writeInt(ptr, dimensionId);
        BUFFER.markDirty();
    }
}

