/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.util;

import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MemoryBuffer {
    private final long stride;
    @Nullable
    private MemoryBlock block;

    public MemoryBuffer(long stride) {
        this.stride = stride;
    }

    public boolean reallocIfNeeded(int index) {
        if (this.block == null) {
            this.block = MemoryBlock.malloc(this.neededCapacityForIndex(index + 8));
            return true;
        }
        if (this.block.size() < this.neededCapacityForIndex(index)) {
            this.block = this.block.realloc(this.neededCapacityForIndex(index + 8));
            return true;
        }
        return false;
    }

    public long ptr() {
        return this.block.ptr();
    }

    public long ptrForIndex(int index) {
        return this.block.ptr() + this.bytePosForIndex(index);
    }

    public long bytePosForIndex(int index) {
        return (long)index * this.stride;
    }

    public long neededCapacityForIndex(int index) {
        return (long)(index + 1) * this.stride;
    }

    public void delete() {
        if (this.block != null) {
            this.block.free();
        }
    }
}

