/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class ShadowRenderHelper {
    private static final class_1921 SHADOW_LAYER = class_12249.method_76010((class_2960)class_2960.method_60656((String)"textures/misc/shadow.png"));

    public static void renderShadow(class_4587 matrixStack, class_11659 queue, float opacity, float radius) {
        queue.method_73483(matrixStack, SHADOW_LAYER, (class_11659.class_11660)new ShadowRenderState(opacity / 2.0f, radius, -1.0f * radius));
    }

    public static void renderShadow(class_4587 matrixStack, class_4597 buffer, class_4538 world, class_243 pos, float opacity, float radius) {
        float f = radius;
        double d2 = pos.method_10216();
        double d0 = pos.method_10214();
        double d1 = pos.method_10215();
        int i = class_3532.method_15357((double)(d2 - (double)f));
        int j = class_3532.method_15357((double)(d2 + (double)f));
        int k = class_3532.method_15357((double)(d0 - (double)f));
        int l = class_3532.method_15357((double)d0);
        int i1 = class_3532.method_15357((double)(d1 - (double)f));
        int j1 = class_3532.method_15357((double)(d1 + (double)f));
        class_4587.class_4665 entry = matrixStack.method_23760();
        class_4588 builder = buffer.method_73477(SHADOW_LAYER);
        for (class_2338 blockpos : class_2338.method_10097((class_2338)new class_2338(i, k, i1), (class_2338)new class_2338(j, l, j1))) {
            ShadowRenderHelper.renderBlockShadow(entry, builder, world, blockpos, d2, d0, d1, f, opacity);
        }
    }

    private static void renderBlockShadow(class_4587.class_4665 entry, class_4588 builder, class_4538 world, class_2338 pos, double x, double y, double z, float radius, float opacity) {
        class_265 voxelshape;
        class_2338 blockpos = pos.method_10074();
        class_2680 blockstate = world.method_8320(blockpos);
        if (blockstate.method_26217() != class_2464.field_11455 && world.method_22339(pos) > 3 && blockstate.method_26234((class_1922)world, blockpos) && !(voxelshape = blockstate.method_26218((class_1922)world, pos.method_10074())).method_1110()) {
            float brightness = class_765.method_23284((class_2874)world.method_8597(), (int)world.method_22339(pos));
            float f = (float)(((double)opacity - (y - (double)pos.method_10264()) / 2.0) * 0.5 * (double)brightness);
            if (f >= 0.0f) {
                if (f > 1.0f) {
                    f = 1.0f;
                }
                class_238 AABB = voxelshape.method_1107();
                double d0 = (double)pos.method_10263() + AABB.field_1323;
                double d1 = (double)pos.method_10263() + AABB.field_1320;
                double d2 = (double)pos.method_10264() + AABB.field_1322;
                double d3 = (double)pos.method_10260() + AABB.field_1321;
                double d4 = (double)pos.method_10260() + AABB.field_1324;
                float f1 = (float)(d0 - x);
                float f2 = (float)(d1 - x);
                float f3 = (float)(d2 - y + 0.015625);
                float f4 = (float)(d3 - z);
                float f5 = (float)(d4 - z);
                float f6 = -f1 / 2.0f / radius + 0.5f;
                float f7 = -f2 / 2.0f / radius + 0.5f;
                float f8 = -f4 / 2.0f / radius + 0.5f;
                float f9 = -f5 / 2.0f / radius + 0.5f;
                ShadowRenderHelper.shadowVertex(entry, builder, f, f1, f3, f4, f6, f8);
                ShadowRenderHelper.shadowVertex(entry, builder, f, f1, f3, f5, f6, f9);
                ShadowRenderHelper.shadowVertex(entry, builder, f, f2, f3, f5, f7, f9);
                ShadowRenderHelper.shadowVertex(entry, builder, f, f2, f3, f4, f7, f8);
            }
        }
    }

    private static void shadowVertex(class_4587.class_4665 entry, class_4588 builder, float alpha, float x, float y, float z, float u, float v) {
        builder.method_22918((Matrix4fc)entry.method_23761(), x, y, z).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, 0.0f, 1.0f, 0.0f);
    }

    @Environment(value=EnvType.CLIENT)
    public record ShadowRenderState(float opacity, float radius, float negativeRadius) implements class_11659.class_11660
    {
        public void render(class_4587.class_4665 entry, class_4588 builder) {
            ShadowRenderHelper.shadowVertex(entry, builder, this.opacity, this.negativeRadius, 0.0f, this.negativeRadius, 0.0f, 0.0f);
            ShadowRenderHelper.shadowVertex(entry, builder, this.opacity, this.negativeRadius, 0.0f, this.radius, 0.0f, 1.0f);
            ShadowRenderHelper.shadowVertex(entry, builder, this.opacity, this.radius, 0.0f, this.radius, 1.0f, 1.0f);
            ShadowRenderHelper.shadowVertex(entry, builder, this.opacity, this.radius, 0.0f, this.negativeRadius, 1.0f, 0.0f);
        }
    }
}

