/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShiftEntry;
import com.zurrtum.create.client.foundation.block.connected.CTType;
import com.zurrtum.create.client.foundation.block.connected.ConnectedTextureBehaviour;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import com.zurrtum.create.content.decoration.copycat.CopycatBlock;
import java.util.List;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10801;
import net.minecraft.class_10817;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5611;
import net.minecraft.class_5819;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class CTModel
extends WrapperBlockStateModel {
    private final ConnectedTextureBehaviour behaviour;

    public CTModel(class_2680 state, class_1087.class_9979 unbaked, ConnectedTextureBehaviour behaviour) {
        super(state, unbaked);
        this.behaviour = behaviour;
    }

    public static BiFunction<class_2680, class_1087.class_9979, class_1087.class_9979> of(ConnectedTextureBehaviour behaviour) {
        return (state, unbaked) -> new CTModel((class_2680)state, (class_1087.class_9979)unbaked, behaviour);
    }

    @Override
    public void addPartsWithInfo(class_1920 world, class_2338 pos, class_2680 state, class_5819 random, List<class_10889> parts) {
        int[] indices = this.createCTData(world, pos, state);
        for (class_10889 part : this.model.method_68512(random)) {
            class_10817.class_10818 builder = new class_10817.class_10818();
            for (class_777 quad : part.method_68509(null)) {
                builder.method_68051(this.replaceQuad(state, random, indices[quad.comp_3723().method_10146()], quad));
            }
            for (class_2350 direction : Iterate.directions) {
                this.addQuads(builder, part, direction, state, random, indices[direction.method_10146()]);
            }
            parts.add((class_10889)new class_10801(builder.method_68050(), part.comp_3751(), part.comp_3752()));
        }
    }

    protected void addQuads(class_10817.class_10818 builder, class_10889 part, class_2350 direction, class_2680 state, class_5819 random, int index) {
        for (class_777 quad : part.method_68509(direction)) {
            builder.method_68053(direction, this.replaceQuad(state, random, index, quad));
        }
    }

    private static long calcSpriteUv(long packedUv, CTSpriteShiftEntry spriteShift, int index) {
        float u = class_5611.method_76641((long)packedUv);
        float v = class_5611.method_76642((long)packedUv);
        return class_5611.method_76640((float)spriteShift.getTargetU(u, index), (float)spriteShift.getTargetV(v, index));
    }

    protected class_777 replaceQuad(class_2680 state, class_5819 random, int index, class_777 quad) {
        if (index == -1) {
            return quad;
        }
        CTSpriteShiftEntry spriteShift = this.behaviour.getShift(state, random, quad.comp_3723(), quad.comp_3724());
        if (spriteShift == null || quad.comp_3724() != spriteShift.getOriginal()) {
            return quad;
        }
        class_777 newQuad = new class_777(quad.comp_5238(), quad.comp_5239(), quad.comp_5240(), quad.comp_5241(), CTModel.calcSpriteUv(quad.comp_5242(), spriteShift, index), CTModel.calcSpriteUv(quad.comp_5243(), spriteShift, index), CTModel.calcSpriteUv(quad.comp_5244(), spriteShift, index), CTModel.calcSpriteUv(quad.comp_5245(), spriteShift, index), quad.comp_3722(), quad.comp_3723(), quad.comp_3724(), quad.comp_3725(), quad.comp_3726());
        NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
        return newQuad;
    }

    protected int[] createCTData(class_1920 world, class_2338 pos, class_2680 state) {
        int[] indices = new int[6];
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (class_2350 face : Iterate.directions) {
            CopycatBlock ufb;
            class_2248 class_22482;
            class_2680 actualState = world.method_8320(pos);
            if (!(this.behaviour.buildContextForOccludedDirections() || class_2248.method_9607((class_2680)state, (class_2680)world.method_8320((class_2338)mutablePos.method_25505((class_2382)pos, face)), (class_2350)face) || (class_22482 = actualState.method_26204()) instanceof CopycatBlock && !(ufb = (CopycatBlock)class_22482).canFaceBeOccluded(actualState, face))) {
                indices[face.method_10146()] = -1;
                continue;
            }
            CTType dataType = this.behaviour.getDataType(world, pos, state, face);
            if (dataType == null) {
                indices[face.method_10146()] = -1;
                continue;
            }
            ConnectedTextureBehaviour.CTContext context = this.behaviour.buildContext(world, pos, state, face, dataType.getContextRequirement());
            indices[face.method_10146()] = dataType.getTextureIndex(context);
        }
        return indices;
    }
}

