/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.model.BakedModelHelper;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TableClothModel
extends WrapperBlockStateModel {
    private static final class_2350[] DIRECTIONS = new class_2350[]{class_2350.field_11035, class_2350.field_11039, class_2350.field_11043, class_2350.field_11034};
    private static final int SOUTH_WEST = 3;
    private static final int NORTH_WEST = 6;
    private static final int NORTH_EAST = 12;
    private static final int SOUTH_EAST = 9;
    private final BakedCorner[] corner = new BakedCorner[16];
    private List<class_777> south;
    private List<class_777> west;
    private List<class_777> north;
    private List<class_777> east;

    public TableClothModel(class_2680 state, class_1087.class_9979 unbaked) {
        super(state, unbaked);
    }

    @Override
    public void addPartsWithInfo(class_1920 world, class_2338 pos, class_2680 state, class_5819 random, List<class_10889> parts) {
        this.model.method_68513(random, parts);
        int index = 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i < 4; ++i) {
            class_2350 direction = DIRECTIONS[i];
            if (!class_2248.method_9607((class_2680)state, (class_2680)world.method_8320((class_2338)mutable.method_25505((class_2382)pos, direction)), (class_2350)direction)) continue;
            index |= 1 << i;
        }
        BakedCorner cache = this.corner[index];
        if (cache != null) {
            parts.add(cache);
            return;
        }
        class_1058 sprite = this.model.method_68511();
        this.corner[index] = new BakedCorner((index & 3) == 3 ? this.getSouth(sprite) : List.of(), (index & 6) == 6 ? this.getWest(sprite) : List.of(), (index & 0xC) == 12 ? this.getNorth(sprite) : List.of(), (index & 9) == 9 ? this.getEast(sprite) : List.of(), sprite);
        parts.add(this.corner[index]);
    }

    private List<class_777> getSouth(class_1058 sprite) {
        if (this.south != null) {
            return this.south;
        }
        this.south = TableClothModel.replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_SW);
        return this.south;
    }

    private List<class_777> getWest(class_1058 sprite) {
        if (this.west != null) {
            return this.west;
        }
        this.west = TableClothModel.replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_NW);
        return this.west;
    }

    private List<class_777> getNorth(class_1058 sprite) {
        if (this.north != null) {
            return this.north;
        }
        this.north = TableClothModel.replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_NE);
        return this.north;
    }

    private List<class_777> getEast(class_1058 sprite) {
        if (this.east != null) {
            return this.east;
        }
        this.east = TableClothModel.replaceQuads(sprite, AllPartialModels.TABLE_CLOTH_SE);
        return this.east;
    }

    private static List<class_777> replaceQuads(class_1058 replace, PartialModel model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_777 quad : model.get().comp_3750().method_68048()) {
            builder.add((Object)TableClothModel.replaceQuad(replace, quad));
        }
        return builder.build();
    }

    private static class_777 replaceQuad(class_1058 replace, class_777 quad) {
        class_1058 original = quad.comp_3724();
        if (original == replace) {
            return quad;
        }
        class_777 newQuad = new class_777(quad.comp_5238(), quad.comp_5239(), quad.comp_5240(), quad.comp_5241(), BakedModelHelper.calcSpriteUv(quad.comp_5242(), original, replace), BakedModelHelper.calcSpriteUv(quad.comp_5243(), original, replace), BakedModelHelper.calcSpriteUv(quad.comp_5244(), original, replace), BakedModelHelper.calcSpriteUv(quad.comp_5245(), original, replace), quad.comp_3722(), quad.comp_3723(), quad.comp_3724(), quad.comp_3725(), quad.comp_3726());
        NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
        return newQuad;
    }

    @Environment(value=EnvType.CLIENT)
    private static final class BakedCorner
    extends Record
    implements class_10889 {
        private final List<class_777> south;
        private final List<class_777> west;
        private final List<class_777> north;
        private final List<class_777> east;
        private final class_1058 particleIcon;

        private BakedCorner(List<class_777> south, List<class_777> west, List<class_777> north, List<class_777> east, class_1058 particleIcon) {
            this.south = south;
            this.west = west;
            this.north = north;
            this.east = east;
            this.particleIcon = particleIcon;
        }

        public List<class_777> method_68509(@Nullable class_2350 side) {
            class_2350 class_23502 = side;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"SOUTH", "WEST", "NORTH", "EAST"}, (class_2350)class_23502, n)) {
                case 0 -> this.south;
                case 1 -> this.west;
                case 2 -> this.north;
                case 3 -> this.east;
                default -> List.of();
            };
        }

        public boolean comp_3751() {
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BakedCorner.class, "south;west;north;east;particleIcon", "south", "west", "north", "east", "particleIcon"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BakedCorner.class, "south;west;north;east;particleIcon", "south", "west", "north", "east", "particleIcon"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BakedCorner.class, "south;west;north;east;particleIcon", "south", "west", "north", "east", "particleIcon"}, this, o);
        }

        public List<class_777> south() {
            return this.south;
        }

        public List<class_777> west() {
            return this.west;
        }

        public List<class_777> north() {
            return this.north;
        }

        public List<class_777> east() {
            return this.east;
        }

        public class_1058 comp_3752() {
            return this.particleIcon;
        }
    }
}

