/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_3611;
import net.minecraft.class_3940;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9326;
import net.minecraft.class_9381;

@Environment(value=EnvType.CLIENT)
public class FluidParticle
extends class_3940 {
    private final float uo;
    private final float vo;
    private final class_3611 fluid;
    private final class_9326 components;
    private final FluidConfig config;

    public FluidParticle(class_638 world, class_3611 fluid, class_9326 components, FluidConfig config, double x, double y, double z, double vx, double vy, double vz, class_5819 random) {
        super(world, x, y, z, vx, vy, vz, config.still().get());
        this.fluid = fluid;
        this.components = components;
        this.config = config;
        this.field_3844 = 1.0f;
        this.updateColor();
        this.multiplyColor(config.tint().apply(components));
        this.field_3852 = vx;
        this.field_3869 = vy;
        this.field_3850 = vz;
        this.field_17867 /= 2.0f;
        this.uo = random.method_43057() * 3.0f;
        this.vo = random.method_43057() * 3.0f;
    }

    protected int method_3068(float p_189214_1_) {
        int brightnessForRender = super.method_3068(p_189214_1_);
        int skyLight = brightnessForRender >> 20;
        int blockLight = brightnessForRender >> 4 & 0xF;
        blockLight = Math.max(blockLight, this.fluid.method_15785().method_15759().method_26213());
        return skyLight << 20 | blockLight << 4;
    }

    protected void updateColor() {
        this.field_62633 = 0.8f;
        this.field_62634 = 0.8f;
        this.field_62635 = 0.8f;
    }

    protected void multiplyColor(int color) {
        this.field_62633 *= (float)(color >> 16 & 0xFF) / 255.0f;
        this.field_62634 *= (float)(color >> 8 & 0xFF) / 255.0f;
        this.field_62635 *= (float)(color & 0xFF) / 255.0f;
    }

    protected float method_18133() {
        return this.field_62632.method_4580((this.uo + 1.0f) / 4.0f);
    }

    protected float method_18134() {
        return this.field_62632.method_4580(this.uo / 4.0f);
    }

    protected float method_18135() {
        return this.field_62632.method_4570(this.vo / 4.0f);
    }

    protected float method_18136() {
        return this.field_62632.method_4570((this.vo + 1.0f) / 4.0f);
    }

    public void method_3070() {
        super.method_3070();
        if (!this.canEvaporate()) {
            return;
        }
        if (this.field_3845) {
            this.method_3085();
        }
        if (!this.field_3843) {
            return;
        }
        if (!this.field_3845 && this.field_3840.method_43057() < 0.125f) {
            return;
        }
        Color color = new Color(this.config.tint().apply(this.components));
        this.field_3851.method_8406((class_2394)class_9381.method_58255((class_2396)class_2398.field_11226, (float)color.getRedAsFloat(), (float)color.getGreenAsFloat(), (float)color.getBlueAsFloat()), this.field_3874, this.field_3854, this.field_3871, 0.0, 0.0, 0.0);
    }

    protected boolean canEvaporate() {
        return this.fluid == AllFluids.POTION;
    }

    protected class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62639;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<FluidParticleData> {
        public class_703 createParticle(FluidParticleData data, class_638 world, double x, double y, double z, double vx, double vy, double vz, class_5819 random) {
            FluidConfig config = AllFluidConfigs.get(data.fluid());
            if (config == null) {
                return null;
            }
            return new FluidParticle(world, data.fluid(), data.components(), config, x, y, z, vx, vy, vz, random);
        }
    }
}

