/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.item;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.material.Materials;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.ModelUtil;
import com.zurrtum.create.client.flywheel.lib.model.SimpleModel;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedItemModelBufferer;
import com.zurrtum.create.client.flywheel.lib.model.baked.ItemChunkLayerSortedListBuilder;
import com.zurrtum.create.client.flywheel.lib.model.baked.MeshHelper;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import com.zurrtum.create.client.vanillin.Vanillin;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenCustomHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10439;
import net.minecraft.class_10444;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_811;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class ItemModels {
    public static final class_6862<class_1792> NO_INSTANCING = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Vanillin.rl("no_instancing"));
    private static final Model EMPTY_MODEL = new SimpleModel(List.of());
    private static final RendererReloadCache<BakedModelKey, Model> MODEL_CACHE = new RendererReloadCache<BakedModelKey, Model>(key -> ItemModels.bakeModel(key.world(), key.stack(), key.displayContext()));
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    public static boolean isSupported(class_1799 stack, class_811 context) {
        if (stack.method_31573(NO_INSTANCING)) {
            return false;
        }
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        Boolean cache = objects.cache.get(stack);
        if (cache != null) {
            return cache;
        }
        class_310 mc = class_310.method_1551();
        class_10444 state = objects.state;
        mc.method_65386().method_65598(state, stack, context, (class_1937)mc.field_1687, null, 0);
        boolean support = !state.method_70948();
        objects.cache.put(stack.method_7972(), support);
        return support;
    }

    public static class_10439 getModel(class_1799 stack) {
        return class_310.method_1551().method_1554().method_65746((class_2960)stack.method_58694(class_9334.field_54199));
    }

    public static Model get(class_1937 world, class_1799 itemStack, class_811 displayContext) {
        if (itemStack.method_7960()) {
            return EMPTY_MODEL;
        }
        class_638 clientWorld = world instanceof class_638 ? (class_638)world : null;
        return MODEL_CACHE.get(new BakedModelKey(clientWorld, itemStack, displayContext));
    }

    public static Model bakeModel(class_638 world, class_1799 itemStack, class_811 displayContext) {
        ItemChunkLayerSortedListBuilder builder = ItemChunkLayerSortedListBuilder.getThreadLocal();
        BakedItemModelBufferer.bufferItemStack(itemStack, (class_1920)world, displayContext, (renderType, shaded, data) -> {
            Material material = ModelUtil.getItemMaterial(renderType);
            if (material == null) {
                material = Materials.TRANSLUCENT_ITEM_ENTITY_ITEM;
            }
            if (itemStack.method_7909() instanceof class_1747 && material.transparency() == Transparency.TRANSLUCENT) {
                material = SimpleMaterial.builderOf(material).transparency(Transparency.ORDER_INDEPENDENT).build();
            }
            SimpleQuadMesh mesh = MeshHelper.blockVerticesToMesh(data, "source=ItemModels,ItemStack=" + String.valueOf(itemStack) + ",renderType=" + String.valueOf(renderType));
            builder.add(renderType, new Model.ConfiguredMesh(material, mesh));
        }, (renderType, material, mesh, translucent) -> {
            if (translucent && itemStack.method_7909() instanceof class_1747 && material.transparency() == Transparency.TRANSLUCENT) {
                material = SimpleMaterial.builderOf(material).transparency(Transparency.ORDER_INDEPENDENT).build();
            }
            builder.add(renderType, new Model.ConfiguredMesh(material, mesh));
        });
        return new SimpleModel((List<Model.ConfiguredMesh>)builder.build());
    }

    @Environment(value=EnvType.CLIENT)
    private static class ThreadLocalObjects {
        private static final Hash.Strategy<class_1799> STACK_STRATEGY = new Hash.Strategy<class_1799>(){

            public int hashCode(class_1799 itemStack) {
                return class_1799.method_57355((class_1799)itemStack);
            }

            public boolean equals(class_1799 itemStack, class_1799 itemStack2) {
                return itemStack == itemStack2 || itemStack != null && itemStack2 != null && class_1799.method_31577((class_1799)itemStack, (class_1799)itemStack2);
            }
        };
        public final class_10444 state = new class_10444();
        public final Map<class_1799, Boolean> cache = new Object2BooleanOpenCustomHashMap(STACK_STRATEGY);

        private ThreadLocalObjects() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record BakedModelKey(class_638 world, class_1799 stack, class_811 displayContext) {
        @Override
        public int hashCode() {
            return Objects.hash(this.world, class_1799.method_57355((class_1799)this.stack), this.displayContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            class_638 otherWorld;
            class_638 class_6383;
            if (!(obj instanceof BakedModelKey)) return false;
            BakedModelKey bakedModelKey = (BakedModelKey)obj;
            try {
                otherWorld = class_6383 = bakedModelKey.world();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            class_638 otherStack = class_6383 = bakedModelKey.stack();
            class_638 otherDisplayContext = class_6383 = bakedModelKey.displayContext();
            boolean stackEqual = this.stack == otherStack || class_1799.method_31577((class_1799)this.stack, (class_1799)otherStack);
            if (this.world != otherWorld) return false;
            if (!stackEqual) return false;
            if (this.displayContext != otherDisplayContext) return false;
            return true;
        }
    }
}

