/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2480;
import net.minecraft.class_2627;
import net.minecraft.class_2769;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5602;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ShulkerBoxVisual
extends AbstractBlockEntityVisual<class_2627>
implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().cutout(CutoutShaders.ONE_TENTH).texture(class_4722.field_21704).mipmap(false).backfaceCulling(false).build();
    private static final Set<String> PATHS_TO_PRUNE = Set.of("/head");
    private final InstanceTree instances;
    private final InstanceTree lid;
    private final Matrix4f initialPose;
    private float lastProgress = Float.NaN;

    public ShulkerBoxVisual(VisualizationContext ctx, class_2627 blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        class_1767 color = blockEntity.method_11320();
        class_4730 texture = color == null ? class_4722.field_21710 : (class_4730)class_4722.field_21711.get(color.method_7789());
        this.instances = InstanceTree.create(this.instancerProvider(), ModelTrees.of(class_5602.field_27596, PATHS_TO_PRUNE, texture, MATERIAL));
        this.lid = this.instances.childOrThrow("lid");
        this.initialPose = this.createInitialPose();
        this.applyTransform(partialTick);
    }

    private Matrix4f createInitialPose() {
        class_2338 visualPosition = this.getVisualPosition();
        Quaternionf rotation = this.getDirection().method_23224();
        return new Matrix4f().translate((float)visualPosition.method_10263(), (float)visualPosition.method_10264(), (float)visualPosition.method_10260()).translate(0.5f, 0.5f, 0.5f).scale(0.9995f).rotate((Quaternionfc)rotation).scale(1.0f, -1.0f, -1.0f).translate(0.0f, -1.0f, 0.0f);
    }

    private class_2350 getDirection() {
        if (this.blockState.method_26204() instanceof class_2480) {
            return (class_2350)this.blockState.method_11654((class_2769)class_2480.field_11496);
        }
        return class_2350.field_11036;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        if (this.doDistanceLimitThisFrame(context) || !this.isVisible(context.frustum())) {
            return;
        }
        this.applyTransform(context.partialTick());
    }

    private void applyTransform(float partialTicks) {
        float progress = ((class_2627)this.blockEntity).method_11312(partialTicks);
        if (progress == this.lastProgress) {
            return;
        }
        this.lastProgress = progress;
        this.lid.yRot(4.712389f * progress);
        this.lid.yPos(24.0f - progress * 8.0f);
        this.instances.updateInstancesStatic((Matrix4fc)this.initialPose);
    }

    @Override
    public void updateLight(float partialTick) {
        int packedLight = this.computePackedLight();
        this.instances.traverse(instance -> instance.light(packedLight).setChanged());
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        this.instances.traverse(consumer);
    }

    @Override
    protected void _delete() {
        this.instances.delete();
    }
}

