/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.eiv;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.compat.eiv.display.AutoCompactingDisplay;
import com.zurrtum.create.compat.eiv.display.AutoMixingDisplay;
import com.zurrtum.create.compat.eiv.display.BlockCuttingDisplay;
import com.zurrtum.create.compat.eiv.display.CompactingDisplay;
import com.zurrtum.create.compat.eiv.display.CrushingDisplay;
import com.zurrtum.create.compat.eiv.display.DeployingDisplay;
import com.zurrtum.create.compat.eiv.display.DrainingDisplay;
import com.zurrtum.create.compat.eiv.display.FanBlastingDisplay;
import com.zurrtum.create.compat.eiv.display.FanHauntingDisplay;
import com.zurrtum.create.compat.eiv.display.FanSmokingDisplay;
import com.zurrtum.create.compat.eiv.display.FanWashingDisplay;
import com.zurrtum.create.compat.eiv.display.ManualApplicationDisplay;
import com.zurrtum.create.compat.eiv.display.MechanicalCraftingDisplay;
import com.zurrtum.create.compat.eiv.display.MilingDisplay;
import com.zurrtum.create.compat.eiv.display.MixingDisplay;
import com.zurrtum.create.compat.eiv.display.MysteriousItemConversionDisplay;
import com.zurrtum.create.compat.eiv.display.PotionDisplay;
import com.zurrtum.create.compat.eiv.display.PressingDisplay;
import com.zurrtum.create.compat.eiv.display.SandPaperPolishingDisplay;
import com.zurrtum.create.compat.eiv.display.SawingDisplay;
import com.zurrtum.create.compat.eiv.display.SequencedAssemblyDisplay;
import com.zurrtum.create.compat.eiv.display.SpoutFillingDisplay;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlock;
import de.crafty.eiv.common.api.IExtendedItemViewIntegration;
import de.crafty.eiv.common.api.recipe.EivRecipeType;
import de.crafty.eiv.common.api.recipe.IEivServerRecipe;
import de.crafty.eiv.common.api.recipe.ItemView;
import de.crafty.eiv.common.builtin.shapeless.ShapelessServerRecipe;
import de.crafty.eiv.common.recipe.ServerRecipeManager;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10289;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1856;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8786;

public class EivCommonPlugin
implements IExtendedItemViewIntegration {
    public static final EivRecipeType<AutoCompactingDisplay> AUTOMATIC_PACKING = EivCommonPlugin.register("automatic_packing", AutoCompactingDisplay::new);
    public static final EivRecipeType<CompactingDisplay> PACKING = EivCommonPlugin.register("packing", CompactingDisplay::new);
    public static final EivRecipeType<PressingDisplay> PRESSING = EivCommonPlugin.register("pressing", PressingDisplay::new);
    public static final EivRecipeType<AutoMixingDisplay> AUTOMATIC_SHAPELESS = EivCommonPlugin.register("automatic_shapeless", AutoMixingDisplay::new);
    public static final EivRecipeType<MixingDisplay> MIXING = EivCommonPlugin.register("mixing", MixingDisplay::new);
    public static final EivRecipeType<MilingDisplay> MILLING = EivCommonPlugin.register("milling", MilingDisplay::new);
    public static final EivRecipeType<SawingDisplay> SAWING = EivCommonPlugin.register("sawing", SawingDisplay::new);
    public static final EivRecipeType<CrushingDisplay> CRUSHING = EivCommonPlugin.register("crushing", CrushingDisplay::new);
    public static final EivRecipeType<MysteriousItemConversionDisplay> MYSTERY_CONVERSION = EivCommonPlugin.register("mystery_conversion", MysteriousItemConversionDisplay::new);
    public static final EivRecipeType<ManualApplicationDisplay> ITEM_APPLICATION = EivCommonPlugin.register("item_application", ManualApplicationDisplay::new);
    public static final EivRecipeType<DeployingDisplay> DEPLOYING = EivCommonPlugin.register("deploying", DeployingDisplay::new);
    public static final EivRecipeType<DrainingDisplay> DRAINING = EivCommonPlugin.register("draining", DrainingDisplay::new);
    public static final EivRecipeType<MechanicalCraftingDisplay> MECHANICAL_CRAFTING = EivCommonPlugin.register("mechanical_crafting", MechanicalCraftingDisplay::new);
    public static final EivRecipeType<SpoutFillingDisplay> SPOUT_FILLING = EivCommonPlugin.register("spout_filling", SpoutFillingDisplay::new);
    public static final EivRecipeType<SandPaperPolishingDisplay> SANDPAPER_POLISHING = EivCommonPlugin.register("sandpaper_polishing", SandPaperPolishingDisplay::new);
    public static final EivRecipeType<SequencedAssemblyDisplay> SEQUENCED_ASSEMBLY = EivCommonPlugin.register("sequenced_assembly", SequencedAssemblyDisplay::new);
    public static final EivRecipeType<FanBlastingDisplay> FAN_BLASTING = EivCommonPlugin.register("fan_blasting", FanBlastingDisplay::new);
    public static final EivRecipeType<FanHauntingDisplay> FAN_HAUNTING = EivCommonPlugin.register("fan_haunting", FanHauntingDisplay::new);
    public static final EivRecipeType<FanSmokingDisplay> FAN_SMOKING = EivCommonPlugin.register("fan_smoking", FanSmokingDisplay::new);
    public static final EivRecipeType<FanWashingDisplay> FAN_WASHING = EivCommonPlugin.register("fan_washing", FanWashingDisplay::new);
    public static final EivRecipeType<PotionDisplay> AUTOMATIC_BREWING = EivCommonPlugin.register("automatic_brewing", PotionDisplay::new);
    public static final EivRecipeType<BlockCuttingDisplay> BLOCK_CUTTING = EivCommonPlugin.register("block_cutting", BlockCuttingDisplay::new);

    private static <T extends IEivServerRecipe> EivRecipeType<T> register(String id, EivRecipeType.EmptyRecipeConstructor<T> factory) {
        return EivRecipeType.register((class_2960)class_2960.method_60655((String)"create", (String)id), factory);
    }

    public void onIntegrationInitialize() {
        ItemView.addRecipeProvider(EivCommonPlugin::register);
    }

    private static void register(List<IEivServerRecipe> recipes) {
        class_10289 preparedRecipes = ServerRecipeManager.INSTANCE.getVanillaRecipeManager().field_54638;
        preparedRecipes.method_64698(AllRecipeTypes.COMPACTING).stream().map(CompactingDisplay::new).forEach(recipes::add);
        Collection craftingRecipes = preparedRecipes.method_64698(class_3956.field_17545);
        craftingRecipes.stream().map(AutoCompactingDisplay::of).filter(Objects::nonNull).forEach(recipes::add);
        craftingRecipes.stream().map(AutoMixingDisplay::of).filter(Objects::nonNull).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.PRESSING).stream().map(PressingDisplay::new).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.MIXING).stream().map(MixingDisplay::new).forEach(recipes::add);
        Collection millingRecipes = preparedRecipes.method_64698(AllRecipeTypes.MILLING);
        millingRecipes.stream().map(MilingDisplay::new).forEach(recipes::add);
        millingRecipes.stream().map(CrushingDisplay::new).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.CUTTING).stream().map(SawingDisplay::new).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.CRUSHING).stream().map(CrushingDisplay::new).forEach(recipes::add);
        Collection manualApplicationRecipes = preparedRecipes.method_64698(AllRecipeTypes.ITEM_APPLICATION);
        manualApplicationRecipes.stream().map(ManualApplicationDisplay::new).forEach(recipes::add);
        manualApplicationRecipes.stream().map(DeployingDisplay::of).filter(Objects::nonNull).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.DEPLOYING).stream().map(DeployingDisplay::of).filter(Objects::nonNull).forEach(recipes::add);
        Collection sandPaperPolishingRecipes = preparedRecipes.method_64698(AllRecipeTypes.SANDPAPER_POLISHING);
        sandPaperPolishingRecipes.stream().map(DeployingDisplay::of).filter(Objects::nonNull).forEach(recipes::add);
        sandPaperPolishingRecipes.stream().map(SandPaperPolishingDisplay::new).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.SEQUENCED_ASSEMBLY).stream().map(SequencedAssemblyDisplay::new).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.EMPTYING).stream().map(DrainingDisplay::new).forEach(recipes::add);
        DrainingDisplay.registerGenericItem(recipes);
        preparedRecipes.method_64698(AllRecipeTypes.MECHANICAL_CRAFTING).stream().map(MechanicalCraftingDisplay::new).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.FILLING).stream().map(SpoutFillingDisplay::new).forEach(recipes::add);
        SpoutFillingDisplay.registerGenericItem(recipes);
        class_5455.class_6890 registryManager = ServerRecipeManager.INSTANCE.getServer().method_30611();
        Collection smokingRecipes = preparedRecipes.method_64698(class_3956.field_17548);
        Collection smeltingRecipes = preparedRecipes.method_64698(class_3956.field_17546);
        smeltingRecipes.stream().map(arg_0 -> EivCommonPlugin.lambda$register$0((class_5455)registryManager, smokingRecipes, arg_0)).filter(Objects::nonNull).forEach(recipes::add);
        preparedRecipes.method_64698(class_3956.field_17547).stream().map(arg_0 -> EivCommonPlugin.lambda$register$1((class_5455)registryManager, smeltingRecipes, smokingRecipes, arg_0)).filter(Objects::nonNull).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.HAUNTING).stream().map(FanHauntingDisplay::new).forEach(recipes::add);
        preparedRecipes.method_64698(class_3956.field_17548).stream().map(FanSmokingDisplay::new).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.SPLASHING).stream().map(FanWashingDisplay::new).forEach(recipes::add);
        preparedRecipes.method_64698(AllRecipeTypes.POTION).stream().map(PotionDisplay::new).forEach(recipes::add);
        MysteriousItemConversionDisplay.register(recipes);
        BlockCuttingDisplay.register(recipes, preparedRecipes);
        EivCommonPlugin.registerToolboxRecipes(recipes, (class_5455)registryManager);
    }

    public static void registerToolboxRecipes(List<IEivServerRecipe> recipes, class_5455 registryManager) {
        class_6885.class_6888 entries = registryManager.method_30530(class_7924.field_41197).method_46735(AllItemTags.TOOLBOXES);
        class_1856 ingredient = class_1856.method_8106((class_6885)entries);
        for (class_1767 color : class_1767.values()) {
            recipes.add((IEivServerRecipe)new ShapelessServerRecipe(List.of(class_1856.method_8101((class_1935)class_1769.method_7803((class_1767)color)), ingredient), ToolboxBlock.getColorBlock(color).method_8389().method_7854()));
        }
    }

    private static /* synthetic */ FanBlastingDisplay lambda$register$1(class_5455 registryManager, Collection smeltingRecipes, Collection smokingRecipes, class_8786 entry) {
        return FanBlastingDisplay.of((class_8786<? extends class_1874>)entry, registryManager, smeltingRecipes, smokingRecipes);
    }

    private static /* synthetic */ FanBlastingDisplay lambda$register$0(class_5455 registryManager, Collection smokingRecipes, class_8786 entry) {
        return FanBlastingDisplay.of((class_8786<? extends class_1874>)entry, registryManager, null, smokingRecipes);
    }
}

