/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.bracket;

import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.decoration.bracket.BracketBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class BracketedBlockEntityBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<BracketedBlockEntityBehaviour> TYPE = new BehaviourType();
    private class_2680 bracket;
    private boolean reRender;
    private Predicate<class_2680> pred;

    public BracketedBlockEntityBehaviour(SmartBlockEntity be) {
        this(be, state -> true);
    }

    public BracketedBlockEntityBehaviour(SmartBlockEntity be, Predicate<class_2680> pred) {
        super(be);
        this.pred = pred;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void applyBracket(class_2680 state) {
        this.bracket = state;
        this.reRender = true;
        this.blockEntity.notifyUpdate();
        class_1937 world = this.getLevel();
        if (world.method_8608()) {
            return;
        }
        this.blockEntity.method_11010().method_30101((class_1936)world, this.getPos(), 3);
    }

    public void transformBracket(StructureTransform transform) {
        if (this.isBracketPresent()) {
            class_2680 transformedBracket = transform.apply(this.bracket);
            this.applyBracket(transformedBracket);
        }
    }

    @Nullable
    public class_2680 removeBracket(boolean inOnReplacedContext) {
        if (this.bracket == null) {
            return null;
        }
        class_2680 removed = this.bracket;
        class_1937 world = this.getLevel();
        if (!world.method_8608()) {
            world.method_20290(2001, this.getPos(), class_2248.method_9507((class_2680)this.bracket));
        }
        this.bracket = null;
        this.reRender = true;
        if (inOnReplacedContext) {
            this.blockEntity.sendData();
            return removed;
        }
        this.blockEntity.notifyUpdate();
        if (world.method_8608()) {
            return removed;
        }
        this.blockEntity.method_11010().method_30101((class_1936)world, this.getPos(), 3);
        return removed;
    }

    public boolean isBracketPresent() {
        return this.bracket != null;
    }

    public boolean isBracketValid(class_2680 bracketState) {
        return bracketState.method_26204() instanceof BracketBlock;
    }

    @Nullable
    public class_2680 getBracket() {
        return this.bracket;
    }

    public boolean canHaveBracket() {
        return this.pred.test(this.blockEntity.method_11010());
    }

    @Override
    public ItemRequirement getRequiredItems() {
        if (!this.isBracketPresent()) {
            return ItemRequirement.NONE;
        }
        return ItemRequirement.of(this.bracket, null);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (this.isBracketPresent() && this.isBracketValid(this.bracket)) {
            view.method_71468("Bracket", class_2680.field_24734, (Object)this.bracket);
        }
        if (clientPacket && this.reRender) {
            view.method_71472("Redraw", true);
            this.reRender = false;
        }
        super.write(view, clientPacket);
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        view.method_71426("Bracket", class_2680.field_24734).ifPresent(state -> {
            this.bracket = null;
            if (this.isBracketValid((class_2680)state)) {
                this.bracket = state;
            }
        });
        if (clientPacket && view.method_71433("Redraw", false)) {
            this.getLevel().method_8413(this.getPos(), this.blockEntity.method_11010(), this.blockEntity.method_11010(), 16);
        }
        super.read(view, clientPacket);
    }
}

