/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.potatoCannon;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileEntityHitAction;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.player.FakePlayerEntity;
import java.util.UUID;
import net.minecraft.class_10124;
import net.minecraft.class_10128;
import net.minecraft.class_10134;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1641;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4019;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9298;
import net.minecraft.class_9334;

public class AllPotatoProjectileEntityHitActions {
    public static void register() {
        AllPotatoProjectileEntityHitActions.register("set_on_fire", SetOnFire.CODEC);
        AllPotatoProjectileEntityHitActions.register("potion_effect", PotionEffect.CODEC);
        AllPotatoProjectileEntityHitActions.register("food_effects", FoodEffects.CODEC);
        AllPotatoProjectileEntityHitActions.register("chorus_teleport", ChorusTeleport.CODEC);
        AllPotatoProjectileEntityHitActions.register("cure_zombie_villager", CureZombieVillager.CODEC);
        AllPotatoProjectileEntityHitActions.register("suspicious_stew", SuspiciousStew.CODEC);
    }

    private static void register(String name, MapCodec<? extends PotatoProjectileEntityHitAction> codec) {
        class_2378.method_10230(CreateRegistries.POTATO_PROJECTILE_ENTITY_HIT_ACTION, (class_2960)class_2960.method_60655((String)"create", (String)name), codec);
    }

    private static void applyEffect(class_1309 entity, class_1293 effect) {
        if (((class_1291)effect.method_5579().comp_349()).method_5561()) {
            class_1937 class_19372 = entity.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                ((class_1291)effect.method_5579().comp_349()).method_5564(serverWorld, null, null, entity, effect.method_5584(), 1.0);
            }
        } else {
            entity.method_6092(effect);
        }
    }

    public record SetOnFire(int ticks) implements PotatoProjectileEntityHitAction
    {
        public static final MapCodec<SetOnFire> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33442.fieldOf("ticks").forGetter(SetOnFire::ticks)).apply((Applicative)instance, SetOnFire::new));

        public static SetOnFire seconds(int seconds) {
            return new SetOnFire(seconds * 20);
        }

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, PotatoProjectileEntityHitAction.Type type) {
            ray.method_17782().method_20803(this.ticks);
            return false;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public record PotionEffect(class_6880<class_1291> effect, int level, int ticks, boolean recoverable) implements PotatoProjectileEntityHitAction
    {
        public static final MapCodec<PotionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41174.method_40294().fieldOf("effect").forGetter(PotionEffect::effect), (App)class_5699.field_33442.fieldOf("level").forGetter(PotionEffect::level), (App)class_5699.field_33442.fieldOf("ticks").forGetter(PotionEffect::ticks), (App)Codec.BOOL.fieldOf("recoverable").forGetter(PotionEffect::recoverable)).apply((Applicative)instance, PotionEffect::new));

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, PotatoProjectileEntityHitAction.Type type) {
            class_1297 entity = ray.method_17782();
            if (entity.method_73183().method_8608()) {
                return true;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                AllPotatoProjectileEntityHitActions.applyEffect(livingEntity, new class_1293(this.effect, this.ticks, this.level - 1));
            }
            return !this.recoverable;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public record FoodEffects(class_10124 foodProperty, boolean recoverable) implements PotatoProjectileEntityHitAction
    {
        public static final MapCodec<FoodEffects> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_10124.field_53770.fieldOf("food_property").forGetter(FoodEffects::foodProperty), (App)Codec.BOOL.fieldOf("recoverable").forGetter(FoodEffects::recoverable)).apply((Applicative)instance, FoodEffects::new));

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, PotatoProjectileEntityHitAction.Type type) {
            class_1297 entity = ray.method_17782();
            class_1937 world = entity.method_73183();
            if (world.method_8608()) {
                return true;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                for (class_10134 effect : this.foodProperty.comp_3089()) {
                    effect.method_62866(world, projectile, livingEntity);
                }
            }
            return !this.recoverable;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public record ChorusTeleport(double teleportDiameter) implements PotatoProjectileEntityHitAction
    {
        public static final MapCodec<ChorusTeleport> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CreateCodecs.POSITIVE_DOUBLE.fieldOf("teleport_diameter").forGetter(ChorusTeleport::teleportDiameter)).apply((Applicative)instance, ChorusTeleport::new));

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, PotatoProjectileEntityHitAction.Type type) {
            class_1297 entity = ray.method_17782();
            class_1937 level = entity.method_73183();
            if (level.method_8608()) {
                return true;
            }
            if (!(entity instanceof class_1309)) {
                return false;
            }
            class_1309 livingEntity = (class_1309)entity;
            double entityX = livingEntity.method_23317();
            double entityY = livingEntity.method_23318();
            double entityZ = livingEntity.method_23321();
            for (int teleportTry = 0; teleportTry < 16; ++teleportTry) {
                double teleportZ;
                double teleportY;
                double teleportX = entityX + (livingEntity.method_59922().method_43058() - 0.5) * this.teleportDiameter;
                if (!livingEntity.method_6082(teleportX, teleportY = class_3532.method_15350((double)(entityY + (double)(livingEntity.method_59922().method_43048((int)this.teleportDiameter) - (int)(this.teleportDiameter / 2.0))), (double)0.0, (double)(level.method_31605() - 1)), teleportZ = entityZ + (livingEntity.method_59922().method_43058() - 0.5) * this.teleportDiameter, true)) continue;
                if (livingEntity.method_5765()) {
                    livingEntity.method_5848();
                }
                class_3414 soundevent = livingEntity instanceof class_4019 ? class_3417.field_24630 : class_3417.field_14890;
                level.method_43128(null, entityX, entityY, entityZ, soundevent, class_3419.field_15248, 1.0f, 1.0f);
                livingEntity.method_5783(soundevent, 1.0f, 1.0f);
                livingEntity.method_18799(class_243.field_1353);
                return true;
            }
            return false;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }
    }

    public static enum CureZombieVillager implements PotatoProjectileEntityHitAction
    {
        INSTANCE;

        private static final FoodEffects EFFECT;
        private static final GameProfile ZOMBIE_CONVERTER_NAME;
        private static final WorldAttached<FakePlayerEntity> ZOMBIE_CONVERTERS;
        public static final MapCodec<CureZombieVillager> CODEC;

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, PotatoProjectileEntityHitAction.Type type) {
            class_1641 zombieVillager;
            class_1297 entity = ray.method_17782();
            class_1937 world = entity.method_73183();
            if (!(entity instanceof class_1641) || !(zombieVillager = (class_1641)entity).method_6059(class_1294.field_5911)) {
                return EFFECT.execute(projectile, ray, type);
            }
            if (world.method_8608()) {
                return false;
            }
            FakePlayerEntity dummy = ZOMBIE_CONVERTERS.get((class_1936)world);
            dummy.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8463, 1));
            zombieVillager.method_5992((class_1657)dummy, class_1268.field_5808);
            return true;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }

        static {
            EFFECT = new FoodEffects(class_10128.field_53786, false);
            ZOMBIE_CONVERTER_NAME = new GameProfile(UUID.fromString("be12d3dc-27d3-4992-8c97-66be53fd49c5"), "Converter");
            ZOMBIE_CONVERTERS = new WorldAttached<FakePlayerEntity>(w -> new FakePlayerEntity((class_3218)w, ZOMBIE_CONVERTER_NAME));
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public static enum SuspiciousStew implements PotatoProjectileEntityHitAction
    {
        INSTANCE;

        public static final MapCodec<SuspiciousStew> CODEC;

        @Override
        public boolean execute(class_1799 projectile, class_3966 ray, PotatoProjectileEntityHitAction.Type type) {
            class_1297 class_12972 = ray.method_17782();
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                class_9298 stew = (class_9298)projectile.method_58695(class_9334.field_49652, (Object)class_9298.field_49362);
                for (class_9298.class_8751 effect : stew.comp_2416()) {
                    livingEntity.method_6092(effect.method_53247());
                }
            }
            return false;
        }

        @Override
        public MapCodec<? extends PotatoProjectileEntityHitAction> codec() {
            return CODEC;
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }
}

