/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.transfer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BBHelper;
import com.zurrtum.create.content.fluids.transfer.FluidManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_4538;

public class FluidDrainingBehaviour
extends FluidManipulationBehaviour {
    public static final BehaviourType<FluidDrainingBehaviour> TYPE = new BehaviourType();
    class_3611 fluid;
    Set<class_2338> validationSet;
    PriorityQueue<FluidManipulationBehaviour.BlockPosEntry> queue;
    boolean isValid;
    List<FluidManipulationBehaviour.BlockPosEntry> validationFrontier;
    Set<class_2338> validationVisited = new HashSet<class_2338>();
    Set<class_2338> newValidationSet;

    public FluidDrainingBehaviour(SmartBlockEntity be) {
        super(be);
        this.validationFrontier = new ArrayList<FluidManipulationBehaviour.BlockPosEntry>();
        this.validationSet = new HashSet<class_2338>();
        this.newValidationSet = new HashSet<class_2338>();
        this.queue = new ObjectHeapPriorityQueue(this::comparePositions);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean pullNext(class_2338 root, boolean simulate) {
        if (!this.frontier.isEmpty()) {
            return false;
        }
        if (!Objects.equals(root, this.rootPos)) {
            this.rebuildContext(root);
            return false;
        }
        if (this.counterpartActed) {
            this.counterpartActed = false;
            this.softReset(root);
            return false;
        }
        if (this.affectedArea == null) {
            this.affectedArea = class_3341.method_34390((class_2382)root, (class_2382)root);
        }
        class_1937 world = this.getLevel();
        if (!this.queue.isEmpty() && !this.isValid) {
            this.rebuildContext(root);
            return false;
        }
        if (this.validationFrontier.isEmpty() && !this.queue.isEmpty() && !simulate && this.revalidateIn == 0) {
            this.revalidate(root);
        }
        if (!simulate && this.infinite) {
            this.blockEntity.award(AllAdvancements.HOSE_PULLEY);
            if (FluidHelper.isLava(this.fluid)) {
                this.blockEntity.award(AllAdvancements.HOSE_PULLEY_LAVA);
            }
            this.playEffect(world, root, this.fluid, true);
            return true;
        }
        while (!this.queue.isEmpty()) {
            class_3611 fluid;
            class_2680 emptied;
            class_2338 currentPos;
            block23: {
                class_2680 blockState;
                currentPos = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.first()).pos();
                emptied = blockState = world.method_8320(currentPos);
                fluid = class_3612.field_15906;
                if (blockState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                    emptied = (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                    fluid = class_3612.field_15910;
                } else {
                    class_2248 class_22482 = blockState.method_26204();
                    if (class_22482 instanceof class_2404) {
                        class_2404 flowingFluid = (class_2404)class_22482;
                        emptied = class_2246.field_10124.method_9564();
                        if ((Integer)blockState.method_11654((class_2769)class_2404.field_11278) == 0) {
                            fluid = flowingFluid.field_11279;
                            break block23;
                        } else {
                            this.affectedArea = BBHelper.encapsulate(this.affectedArea, class_3341.method_34390((class_2382)currentPos, (class_2382)currentPos));
                            if (!this.blockEntity.isVirtual()) {
                                world.method_8652(currentPos, emptied, 18);
                            }
                            this.queue.dequeue();
                            if (!this.queue.isEmpty()) continue;
                            this.isValid = this.checkValid(world, this.rootPos);
                            this.reset();
                            continue;
                        }
                    }
                    if (blockState.method_26227().method_15772() != class_3612.field_15906 && blockState.method_26194((class_1922)world, currentPos, class_3726.method_16194()).method_1110()) {
                        fluid = blockState.method_26227().method_15772();
                        emptied = class_2246.field_10124.method_9564();
                    }
                }
            }
            if (this.fluid == null) {
                this.fluid = fluid;
            }
            if (!this.fluid.method_15780(fluid)) {
                this.queue.dequeue();
                if (!this.queue.isEmpty()) continue;
                this.isValid = this.checkValid(world, this.rootPos);
                this.reset();
                continue;
            }
            if (simulate) {
                return true;
            }
            this.playEffect(world, currentPos, fluid, true);
            this.blockEntity.award(AllAdvancements.HOSE_PULLEY);
            if (!this.blockEntity.isVirtual()) {
                world.method_8652(currentPos, emptied, 18);
                class_2680 stateAbove = world.method_8320(currentPos.method_10084());
                if (stateAbove.method_26227().method_15772() == class_3612.field_15906 && !stateAbove.method_26184((class_4538)world, currentPos.method_10084())) {
                    world.method_8652(currentPos.method_10084(), class_2246.field_10124.method_9564(), 18);
                }
            }
            this.affectedArea = BBHelper.encapsulate(this.affectedArea, currentPos);
            this.queue.dequeue();
            if (this.queue.isEmpty()) {
                this.isValid = this.checkValid(world, this.rootPos);
                this.reset();
                return true;
            }
            if (this.validationSet.contains(currentPos)) return true;
            this.reset();
            return true;
        }
        if (this.rootPos == null) {
            return false;
        }
        if (!this.isValid) return false;
        this.rebuildContext(root);
        return false;
    }

    protected void softReset(class_2338 root) {
        this.queue.clear();
        this.validationSet.clear();
        this.newValidationSet.clear();
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.visited.clear();
        this.infinite = false;
        this.setValidationTimer();
        this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.blockEntity.sendData();
    }

    protected boolean checkValid(class_1937 world, class_2338 root) {
        class_2338 currentPos = root;
        for (int timeout = 1000; timeout > 0 && !root.equals((Object)this.blockEntity.method_11016()); --timeout) {
            FluidBlockType canPullFluidsFrom = this.canPullFluidsFrom(world.method_8320(currentPos), currentPos);
            if (canPullFluidsFrom == FluidBlockType.FLOWING) {
                for (class_2350 d : Iterate.directions) {
                    class_2338 side = currentPos.method_10093(d);
                    if (this.canPullFluidsFrom(world.method_8320(side), side) != FluidBlockType.SOURCE) continue;
                    return true;
                }
            } else {
                if (canPullFluidsFrom != FluidBlockType.SOURCE) break;
                return true;
            }
            currentPos = currentPos.method_10084();
        }
        return false;
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (!clientPacket && this.affectedArea != null) {
            this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(this.rootPos, 0));
        }
    }

    protected FluidBlockType canPullFluidsFrom(class_2680 blockState, class_2338 pos) {
        if (blockState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            return FluidBlockType.SOURCE;
        }
        if (blockState.method_26204() instanceof class_2404) {
            return (Integer)blockState.method_11654((class_2769)class_2404.field_11278) == 0 ? FluidBlockType.SOURCE : FluidBlockType.FLOWING;
        }
        if (blockState.method_26227().method_15772() != class_3612.field_15906 && blockState.method_26194((class_1922)this.getLevel(), pos, class_3726.method_16194()).method_1110()) {
            return FluidBlockType.SOURCE;
        }
        return FluidBlockType.NONE;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.rootPos != null) {
            this.isValid = this.checkValid(this.getLevel(), this.rootPos);
        }
        if (!this.frontier.isEmpty()) {
            this.continueSearch();
            return;
        }
        if (!this.validationFrontier.isEmpty()) {
            this.continueValidation();
            return;
        }
        if (this.revalidateIn > 0) {
            --this.revalidateIn;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
    }

    public void rebuildContext(class_2338 root) {
        this.reset();
        this.rootPos = root;
        this.affectedArea = class_3341.method_34390((class_2382)this.rootPos, (class_2382)this.rootPos);
        if (this.isValid) {
            this.frontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        }
    }

    public void revalidate(class_2338 root) {
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.newValidationSet.clear();
        this.validationFrontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.setValidationTimer();
    }

    private void continueSearch() {
        try {
            this.fluid = this.search(this.fluid, this.frontier, this.visited, (e, d) -> {
                this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry((class_2338)e, (int)d));
                this.validationSet.add((class_2338)e);
            }, false);
        }
        catch (FluidManipulationBehaviour.ChunkNotLoadedException e2) {
            this.blockEntity.sendData();
            this.frontier.clear();
            this.visited.clear();
        }
        int maxBlocks = this.maxBlocks();
        if (this.visited.size() >= maxBlocks && this.canDrainInfinitely(this.fluid) && !this.queue.isEmpty()) {
            this.infinite = true;
            class_2338 firstValid = ((FluidManipulationBehaviour.BlockPosEntry)this.queue.first()).pos();
            this.frontier.clear();
            this.visited.clear();
            this.queue.clear();
            this.queue.enqueue((Object)new FluidManipulationBehaviour.BlockPosEntry(firstValid, 0));
            this.blockEntity.sendData();
            return;
        }
        if (!this.frontier.isEmpty()) {
            return;
        }
        this.blockEntity.sendData();
        this.visited.clear();
    }

    private void continueValidation() {
        try {
            this.search(this.fluid, this.validationFrontier, this.validationVisited, (e, d) -> this.newValidationSet.add((class_2338)e), false);
        }
        catch (FluidManipulationBehaviour.ChunkNotLoadedException e2) {
            this.validationFrontier.clear();
            this.validationVisited.clear();
            this.setLongValidationTimer();
            return;
        }
        int maxBlocks = this.maxBlocks();
        if (this.validationVisited.size() >= maxBlocks && this.canDrainInfinitely(this.fluid)) {
            if (!this.infinite) {
                this.reset();
            }
            this.validationFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        if (!this.validationFrontier.isEmpty()) {
            return;
        }
        if (this.infinite) {
            this.reset();
            return;
        }
        this.validationSet = this.newValidationSet;
        this.newValidationSet = new HashSet<class_2338>();
        this.validationVisited.clear();
    }

    @Override
    public void reset() {
        super.reset();
        this.fluid = null;
        this.rootPos = null;
        this.queue.clear();
        this.validationSet.clear();
        this.newValidationSet.clear();
        this.validationFrontier.clear();
        this.validationVisited.clear();
        this.blockEntity.sendData();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    protected boolean isSearching() {
        return !this.frontier.isEmpty();
    }

    public FluidStack getDrainableFluid(class_2338 rootPos) {
        return this.fluid == null || this.isSearching() || !this.pullNext(rootPos, true) ? FluidStack.EMPTY : new FluidStack(this.fluid, 81000);
    }

    protected static enum FluidBlockType {
        NONE,
        SOURCE,
        FLOWING;

    }
}

