/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.vault;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.api.packager.InventoryIdentifier;
import com.zurrtum.create.content.logistics.vault.ItemVaultBlock;
import com.zurrtum.create.foundation.block.NeighborChangeListeningBlock;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventory;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3829;
import net.minecraft.class_4076;
import net.minecraft.class_4538;

public class ItemVaultBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory,
class_3829 {
    protected Supplier<ItemInventory> itemCapability = null;
    protected InventoryIdentifier invId;
    protected ItemVaultHandler inventory = new ItemVaultHandler();
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius = 1;
    protected int length = 1;
    protected class_2350.class_2351 axis;

    public ItemVaultBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ITEM_VAULT, pos, state);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.inventory);
        this.field_11863.method_8544(pos);
        ConnectivityHandler.splitMulti(this);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863.method_8608()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    protected void updateComparators() {
        ItemVaultBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        this.field_11863.method_8524(controllerBE.field_11867);
        class_2338 pos = controllerBE.method_11016();
        int radius = controllerBE.radius;
        int length = controllerBE.length;
        class_2350.class_2351 axis = controllerBE.getMainConnectionAxis();
        int zMax = axis == class_2350.class_2351.field_11048 ? radius : length;
        int xMax = axis == class_2350.class_2351.field_11051 ? radius : length;
        class_2338.class_2339 updatePos = new class_2338.class_2339();
        class_2338.class_2339 provokingPos = new class_2338.class_2339();
        for (int y = 0; y < radius; ++y) {
            for (int z = 0; z < zMax; ++z) {
                for (int x = 0; x < xMax; ++x) {
                    int sectionZ;
                    int sectionX = class_4076.method_18675((int)(pos.method_10263() + x));
                    if (!this.field_11863.method_8393(sectionX, sectionZ = class_4076.method_18675((int)(pos.method_10260() + z)))) continue;
                    provokingPos.method_25504((class_2382)pos, x, y, z);
                    class_2248 provokingBlock = this.field_11863.method_8320((class_2338)provokingPos).method_26204();
                    if (y == 0) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.field_11863, provokingBlock, (class_2338)provokingPos, updatePos, class_2350.field_11033);
                    }
                    if (y == radius - 1) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.field_11863, provokingBlock, (class_2338)provokingPos, updatePos, class_2350.field_11036);
                    }
                    if (z == 0) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.field_11863, provokingBlock, (class_2338)provokingPos, updatePos, class_2350.field_11043);
                    }
                    if (z == zMax - 1) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.field_11863, provokingBlock, (class_2338)provokingPos, updatePos, class_2350.field_11035);
                    }
                    if (x == 0) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.field_11863, provokingBlock, (class_2338)provokingPos, updatePos, class_2350.field_11039);
                    }
                    if (x != xMax - 1) continue;
                    ItemVaultBlockEntity.updateComparatorsInner(this.field_11863, provokingBlock, (class_2338)provokingPos, updatePos, class_2350.field_11034);
                }
            }
        }
    }

    private static void updateComparatorsInner(class_1937 level, class_2248 provokingBlock, class_2338 provokingPos, class_2338.class_2339 updatePos, class_2350 direction) {
        updatePos.method_25505((class_2382)provokingPos, direction);
        int sectionX = class_4076.method_18675((int)updatePos.method_10263());
        int sectionZ = class_4076.method_18675((int)updatePos.method_10260());
        if (!level.method_8393(sectionX, sectionZ)) {
            return;
        }
        class_2680 blockstate = level.method_8320((class_2338)updatePos);
        class_2248 class_22482 = blockstate.method_26204();
        if (class_22482 instanceof NeighborChangeListeningBlock) {
            NeighborChangeListeningBlock block = (NeighborChangeListeningBlock)class_22482;
            block.onNeighborChange(blockstate, (class_4538)level, (class_2338)updatePos, provokingPos);
        }
        if (blockstate.method_27852(class_2246.field_10377)) {
            level.method_41410(blockstate, (class_2338)updatePos, provokingBlock, null, false);
        } else if (blockstate.method_26212((class_1922)level, (class_2338)updatePos)) {
            updatePos.method_10098(direction);
            blockstate = level.method_8320((class_2338)updatePos);
            if (blockstate.method_27852(class_2246.field_10377)) {
                level.method_41410(blockstate, (class_2338)updatePos, provokingBlock, null, false);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.method_11016();
        } else if (!this.lastKnownPos.equals((Object)this.field_11867) && this.field_11867 != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    @Override
    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    public ItemVaultBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        class_2586 blockEntity = this.field_11863.method_8321(this.controller);
        if (blockEntity instanceof ItemVaultBlockEntity) {
            return (ItemVaultBlockEntity)blockEntity;
        }
        return null;
    }

    @Override
    public void removeController(boolean keepContents) {
        if (this.field_11863.method_8608()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        class_2680 state = this.method_11010();
        if (ItemVaultBlock.isVault(state)) {
            state = (class_2680)state.method_11657((class_2769)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.method_10997().method_8652(this.field_11867, state, 22);
        }
        this.itemCapability = null;
        this.method_5431();
        this.sendData();
    }

    @Override
    public void setController(class_2338 controller) {
        if (this.field_11863.method_8608() && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability = null;
        this.method_5431();
        this.sendData();
    }

    @Override
    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        boolean changeOfController;
        super.read(view, clientPacket);
        class_2338 controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = view.method_71433("Uninitialized", false);
        this.lastKnownPos = view.method_71426("LastKnownPos", class_2338.field_25064).orElse(null);
        this.controller = view.method_71426("Controller", class_2338.field_25064).orElse(null);
        if (this.isController()) {
            this.radius = view.method_71424("Size", 0);
            this.length = view.method_71424("Length", 0);
        }
        if (!clientPacket) {
            this.inventory.read(view);
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.method_11002() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.field_11863.method_16109(this.method_11016(), class_2246.field_10124.method_9564(), this.method_11010());
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        if (this.updateConnectivity) {
            view.method_71472("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            view.method_71468("LastKnownPos", class_2338.field_25064, (Object)this.lastKnownPos);
        }
        if (this.isController()) {
            view.method_71465("Size", this.radius);
            view.method_71465("Length", this.length);
        } else {
            view.method_71468("Controller", class_2338.field_25064, (Object)this.controller);
        }
        super.write(view, clientPacket);
        if (!clientPacket) {
            view.method_71469("StorageType", "CombinedInv");
            this.inventory.write(view);
        }
    }

    public void method_5448() {
        this.inventory.method_5448();
    }

    public ItemVaultHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public InventoryIdentifier getInvId() {
        this.initCapability();
        return this.invId;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        int i;
        int size = handler.method_5439();
        for (i = 0; i < size; ++i) {
            this.inventory.method_5447(i, handler.method_5438(i));
        }
        int max = this.inventory.method_5439();
        for (i = size; i < max; ++i) {
            this.inventory.method_5447(i, class_1799.field_8037);
        }
    }

    public void initCapability() {
        if (!this.isController()) {
            ItemVaultBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            if (controllerBE.itemCapability == null || controllerBE.itemCapability.get() == null) {
                controllerBE.initCapability();
            }
            this.itemCapability = () -> {
                if (controllerBE.method_11015()) {
                    return null;
                }
                if (controllerBE.itemCapability == null) {
                    return null;
                }
                return controllerBE.itemCapability.get();
            };
            this.invId = controllerBE.invId;
            return;
        }
        boolean alongZ = ItemVaultBlock.getVaultBlockAxis(this.method_11010()) == class_2350.class_2351.field_11051;
        ItemVaultHandler[] invs = new ItemVaultHandler[this.length * this.radius * this.radius];
        block0: for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    class_2338 vaultPos = alongZ ? this.field_11867.method_10069(xOffset, zOffset, yOffset) : this.field_11867.method_10069(yOffset, xOffset, zOffset);
                    ItemVaultBlockEntity vaultAt = (ItemVaultBlockEntity)ConnectivityHandler.partAt(AllBlockEntityTypes.ITEM_VAULT, (class_1922)this.field_11863, vaultPos);
                    if (vaultAt == null) {
                        invs = null;
                        break block0;
                    }
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt.inventory;
                }
            }
        }
        if (invs == null) {
            this.itemCapability = null;
        } else {
            ConnectedItemVaultHandler capability = new ConnectedItemVaultHandler(invs);
            this.itemCapability = () -> capability;
        }
        class_2338 farCorner = alongZ ? this.field_11867.method_10069(this.radius, this.radius, this.length) : this.field_11867.method_10069(this.length, this.radius, this.radius);
        class_3341 bounds = class_3341.method_34390((class_2382)this.field_11867, (class_2382)farCorner);
        this.invId = new InventoryIdentifier.Bounds(bounds);
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @Override
    public void notifyMultiUpdated() {
        class_2680 state = this.method_11010();
        if (ItemVaultBlock.isVault(state)) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability = null;
        this.method_5431();
    }

    @Override
    public class_2350.class_2351 getMainConnectionAxis() {
        return this.getMainAxisOf(this);
    }

    @Override
    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052) {
            return this.getMaxWidth();
        }
        return ItemVaultBlockEntity.getMaxLength(width);
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.length;
    }

    @Override
    public int getWidth() {
        return this.radius;
    }

    @Override
    public void setHeight(int height) {
        this.length = height;
    }

    @Override
    public void setWidth(int width) {
        this.radius = width;
    }

    @Override
    public boolean hasInventory() {
        return true;
    }

    public class ItemVaultHandler
    implements ItemInventory {
        private final int size;
        protected final class_2371<class_1799> stacks;

        public ItemVaultHandler() {
            this.size = (Integer)AllConfigs.server().logistics.vaultCapacity.get();
            this.stacks = class_2371.method_10213((int)this.size, (Object)class_1799.field_8037);
        }

        public int method_5439() {
            return this.size;
        }

        public class_1799 method_5438(int slot) {
            if (slot >= this.size) {
                return class_1799.field_8037;
            }
            return (class_1799)this.stacks.get(slot);
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot >= this.size) {
                return;
            }
            this.stacks.set(slot, (Object)stack);
        }

        @Override
        public void method_5431() {
            ItemVaultBlockEntity.this.field_11863.method_8524(ItemVaultBlockEntity.this.field_11867);
        }

        public void write(class_11372 view) {
            class_11372.class_11373 list = view.method_71467("Inventory", class_1799.field_24671);
            for (class_1799 stack : this.stacks) {
                if (stack.method_7960()) continue;
                list.method_71484((Object)stack);
            }
        }

        public void read(class_11368 view) {
            class_11368.class_11369 list = view.method_71437("Inventory", class_1799.field_24671);
            int i = 0;
            for (class_1799 itemStack : list) {
                this.stacks.set(i++, (Object)itemStack);
            }
            int size = this.stacks.size();
            while (i < size) {
                this.stacks.set(i, (Object)class_1799.field_8037);
                ++i;
            }
        }
    }

    public class ConnectedItemVaultHandler
    implements ItemInventory,
    VersionedInventory {
        private final ItemVaultHandler[] itemHandler;
        private final int vaultCapacity;
        private final int size;
        private final int id;
        private final BitSet accessed;
        private int version;

        public ConnectedItemVaultHandler(ItemVaultHandler[] invs) {
            this.vaultCapacity = (Integer)AllConfigs.server().logistics.vaultCapacity.get();
            this.itemHandler = invs;
            this.size = this.vaultCapacity * invs.length;
            this.id = idGenerator.getAndIncrement();
            this.accessed = new BitSet(invs.length);
            this.version = 0;
        }

        public int method_5439() {
            return this.size;
        }

        public class_1799 method_5438(int slot) {
            if (slot >= this.size) {
                return class_1799.field_8037;
            }
            int i = slot / this.vaultCapacity;
            this.accessed.set(i);
            return this.itemHandler[i].method_5438(slot % this.vaultCapacity);
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot >= this.size) {
                return;
            }
            int i = slot / this.vaultCapacity;
            ItemVaultHandler handler = this.itemHandler[i];
            handler.method_5447(slot % this.vaultCapacity, stack);
            handler.method_5431();
        }

        public int insert(class_1799 stack) {
            int maxAmount;
            if (stack.method_7960()) {
                return 0;
            }
            int remaining = maxAmount = stack.method_7947();
            for (ItemVaultHandler handler : this.itemHandler) {
                int insert = handler.insert(stack);
                if (remaining == insert) {
                    this.incrementVersion();
                    stack.method_7939(maxAmount);
                    return maxAmount;
                }
                if (insert == 0) continue;
                stack.method_7939(remaining -= insert);
            }
            if (remaining == maxAmount) {
                return 0;
            }
            this.incrementVersion();
            stack.method_7939(maxAmount);
            return maxAmount - remaining;
        }

        public int extract(class_1799 stack) {
            int maxAmount;
            if (stack.method_7960()) {
                return 0;
            }
            int remaining = maxAmount = stack.method_7947();
            for (ItemVaultHandler handler : this.itemHandler) {
                int extract = handler.extract(stack);
                if (remaining == extract) {
                    this.incrementVersion();
                    stack.method_7939(maxAmount);
                    return maxAmount;
                }
                if (extract == 0) continue;
                stack.method_7939(remaining -= extract);
            }
            if (remaining == maxAmount) {
                return 0;
            }
            this.incrementVersion();
            stack.method_7939(maxAmount);
            return maxAmount - remaining;
        }

        public class_1799 extract(Predicate<class_1799> predicate, int maxAmount) {
            if (maxAmount == 0) {
                return class_1799.field_8037;
            }
            int size = this.itemHandler.length;
            for (int i = 0; i < size; ++i) {
                class_1799 findStack = this.itemHandler[i].extract(predicate, maxAmount);
                if (findStack == class_1799.field_8037) continue;
                int extract = findStack.method_7947();
                if (extract == maxAmount) {
                    this.incrementVersion();
                    return findStack;
                }
                if (++i == size) {
                    this.incrementVersion();
                    return findStack;
                }
                int remaining = maxAmount - extract;
                while (i < size) {
                    extract = this.itemHandler[i].extract(findStack);
                    if (remaining == extract) {
                        this.incrementVersion();
                        findStack.method_7939(maxAmount);
                        return findStack;
                    }
                    if (extract != 0) {
                        findStack.method_7939(remaining -= extract);
                    }
                    ++i;
                }
                this.incrementVersion();
                findStack.method_7939(maxAmount - remaining);
                return findStack;
            }
            return class_1799.field_8037;
        }

        public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount) {
            if (maxAmount == 0) {
                return class_1799.field_8037;
            }
            int size = this.itemHandler.length;
            for (int i = 0; i < size; ++i) {
                class_1799 findStack = this.itemHandler[i].count(predicate, maxAmount);
                if (findStack.method_7960()) continue;
                int count = findStack.method_7947();
                if (count == maxAmount) {
                    this.itemHandler[i].extract(findStack);
                    this.incrementVersion();
                    return findStack;
                }
                if (++i == size) break;
                int[] extracts = new int[size];
                int remaining = maxAmount - count;
                while (i < size) {
                    int extract = this.itemHandler[i].count(findStack, remaining);
                    if (extract != 0) {
                        extracts[i] = extract;
                        if (remaining > extract) {
                            remaining -= extract;
                        } else {
                            this.itemHandler[0].extract(findStack);
                            for (int j = 1; j <= i; ++j) {
                                extract = extracts[j];
                                if (extract == 0) continue;
                                findStack.method_7939(extract);
                                this.itemHandler[j].extract(findStack);
                            }
                            this.incrementVersion();
                            findStack.method_7939(maxAmount);
                            return findStack;
                        }
                    }
                    ++i;
                }
            }
            return class_1799.field_8037;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void method_5431() {
            for (ItemVaultHandler inventory : this.itemHandler) {
                inventory.method_5431();
            }
            this.incrementVersion();
        }

        private void incrementVersion() {
            ItemVaultBlockEntity.this.updateComparators();
            ++this.version;
        }
    }
}

