/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class TrainMigration {
    Couple<TrackNodeLocation> locations;
    double positionOnOldEdge;
    boolean curve;
    class_243 fallback;

    public TrainMigration() {
    }

    public TrainMigration(TravellingPoint point) {
        double t = point.position / point.edge.getLength();
        this.fallback = point.edge.getPosition(null, t);
        this.curve = point.edge.isTurn();
        this.positionOnOldEdge = point.position;
        this.locations = Couple.create(point.node1.getLocation(), point.node2.getLocation());
    }

    public TrackGraphLocation tryMigratingTo(TrackGraph graph) {
        TrackEdge edge;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)this.locations.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)this.locations.getSecond()));
        if (node1 != null && node2 != null && (edge = graph.getConnectionsFrom(node1).get(node2)) != null) {
            TrackGraphLocation graphLocation = new TrackGraphLocation();
            graphLocation.graph = graph;
            graphLocation.edge = this.locations;
            graphLocation.position = this.positionOnOldEdge;
            return graphLocation;
        }
        if (this.curve) {
            return null;
        }
        class_243 prevDirection = ((TrackNodeLocation)((Object)this.locations.getSecond())).getLocation().method_1020(((TrackNodeLocation)((Object)this.locations.getFirst())).getLocation()).method_1029();
        for (TrackNodeLocation loc : graph.getNodes()) {
            class_243 nodeVec = loc.getLocation();
            if (nodeVec.method_1025(this.fallback) > 1024.0) continue;
            TrackNode newNode1 = graph.locateNode(loc);
            for (Map.Entry<TrackNode, TrackEdge> entry : graph.getConnectionsFrom(newNode1).entrySet()) {
                class_243 intersectSphere;
                TrackEdge edge2 = entry.getValue();
                if (edge2.isTurn()) continue;
                TrackNode newNode2 = entry.getKey();
                float radius = 0.015625f;
                class_243 direction = edge2.getDirection(true);
                if (!class_3532.method_20390((double)direction.method_1026(prevDirection), (double)1.0) || (intersectSphere = VecHelper.intersectSphere(nodeVec, direction, this.fallback, radius)) == null || !class_3532.method_20390((double)direction.method_1026(intersectSphere.method_1020(nodeVec).method_1029()), (double)1.0)) continue;
                double edgeLength = edge2.getLength();
                double position = intersectSphere.method_1022(nodeVec) - (double)radius;
                if (Double.isNaN(position) || position < 0.0 || position > edgeLength) continue;
                TrackGraphLocation graphLocation = new TrackGraphLocation();
                graphLocation.graph = graph;
                graphLocation.edge = Couple.create(loc, newNode2.getLocation());
                graphLocation.position = position;
                return graphLocation;
            }
        }
        return null;
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71472("Curve", this.curve);
        view.method_71468("Fallback", class_243.field_38277, (Object)this.fallback);
        view.method_71463("Position", this.positionOnOldEdge);
        class_11372.class_11374 list = view.method_71476("Nodes");
        ((TrackNodeLocation)((Object)this.locations.getFirst())).write(list.method_71480(), dimensions);
        ((TrackNodeLocation)((Object)this.locations.getSecond())).write(list.method_71480(), dimensions);
    }

    public static <T> DataResult<T> encode(TrainMigration input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Curve", ops.createBoolean(input.curve));
        map.add("Fallback", (Object)input.fallback, (Encoder)class_243.field_38277);
        map.add("Curve", ops.createDouble(input.positionOnOldEdge));
        ListBuilder list = ops.listBuilder();
        list.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)input.locations.getFirst()), ops, empty, dimensions));
        list.add(TrackNodeLocation.encode((TrackNodeLocation)((Object)input.locations.getSecond()), ops, empty, dimensions));
        map.add("Nodes", list.build(empty));
        return map.build(empty);
    }

    public static TrainMigration read(class_11368 view, DimensionPalette dimensions) {
        TrainMigration trainMigration = new TrainMigration();
        trainMigration.curve = view.method_71433("Curve", false);
        trainMigration.fallback = view.method_71426("Fallback", class_243.field_38277).orElse(class_243.field_1353);
        trainMigration.positionOnOldEdge = view.method_71422("Position", 0.0);
        Iterator iterator = view.method_71438("Nodes").iterator();
        trainMigration.locations = Couple.create(TrackNodeLocation.read((class_11368)iterator.next(), dimensions), TrackNodeLocation.read((class_11368)iterator.next(), dimensions));
        return trainMigration;
    }

    public static <T> TrainMigration decode(DynamicOps<T> ops, T input, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        TrainMigration trainMigration = new TrainMigration();
        trainMigration.curve = ops.getBooleanValue(map.get("Curve")).result().orElse(false);
        trainMigration.fallback = class_243.field_38277.parse(ops, map.get("Fallback")).result().orElse(class_243.field_1353);
        trainMigration.positionOnOldEdge = ops.getNumberValue(map.get("Position"), (Number)0).doubleValue();
        Iterator iterator = ((Stream)ops.getStream(map.get("Nodes")).getOrThrow()).iterator();
        trainMigration.locations = Couple.create(TrackNodeLocation.decode(ops, iterator.next(), dimensions), TrackNodeLocation.decode(ops, iterator.next(), dimensions));
        return trainMigration;
    }
}

