/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.block.fluid.flow;

import com.google.common.collect.Maps;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.bytes.Byte2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.EnumMap;
import java.util.Map;
import net.caffeinemc.mods.lithium.common.util.DirectionConstants;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2478;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import net.minecraft.class_6862;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3609.class})
public abstract class FlowingFluidMixin {
    @Shadow
    public abstract class_3611 method_15750();

    @Shadow
    private static native boolean method_15732(class_2350 var0, class_1922 var1, class_2338 var2, class_2680 var3, class_2338 var4, class_2680 var5);

    @Shadow
    private static native boolean method_15754(class_1922 var0, class_2338 var1, class_2680 var2, class_3611 var3);

    @Shadow
    private static native boolean method_61815(class_1922 var0, class_2338 var1, class_2680 var2, class_3611 var3);

    @Redirect(method={"method_61814(Lnet/minecraft/class_2680;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_2680;method_26164(Lnet/minecraft/class_6862;)Z"))
    private static boolean isSign(class_2680 blockState, class_6862<class_2248> tagKey, @Local class_2248 block) {
        if (tagKey == class_3481.field_15500) {
            return block instanceof class_2478;
        }
        return blockState.method_26164(tagKey);
    }

    @Shadow
    public abstract class_3611 method_15751();

    @Shadow
    protected abstract int method_15733(class_4538 var1);

    @Shadow
    protected abstract class_3610 method_15727(class_3218 var1, class_2338 var2, class_2680 var3);

    @Unique
    private static int getNumIndicesFromRadius(int radius) {
        return (radius + 1) * (2 * radius + 1);
    }

    @Unique
    private static byte indexFromDiamondXZOffset(class_2338 originPos, class_2338 offsetPos, int radius) {
        int xOffset = offsetPos.method_10263() - originPos.method_10263();
        int zOffset = offsetPos.method_10260() - originPos.method_10260();
        int row = (xOffset + zOffset + radius) / 2;
        int column = xOffset - zOffset + radius;
        int rowLength = 2 * radius + 1;
        return (byte)(row * rowLength + column);
    }

    @Shadow
    protected abstract boolean method_61813(class_1922 var1, class_2338 var2, class_2680 var3, class_2350 var4, class_2338 var5, class_2680 var6, class_3610 var7);

    @Inject(method={"method_15726(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;)Ljava/util/Map;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSpread(class_3218 world, class_2338 pos, class_2680 state, CallbackInfoReturnable<Map<class_2350, class_3610>> cir) {
        class_3610 targetNewFluidState;
        class_3610 onlyFluidState;
        EnumMap flowResultByDirection = Maps.newEnumMap(class_2350.class);
        int searchRadius = this.method_15733((class_4538)world) + 1;
        int numIndicesFromRadius = FlowingFluidMixin.getNumIndicesFromRadius(searchRadius);
        if (numIndicesFromRadius > 256) {
            return;
        }
        class_2680[] blockStateCache = new class_2680[numIndicesFromRadius];
        class_2350 onlyPossibleFlowDirection = null;
        class_2338 onlyBlockPos = null;
        class_2680 onlyBlockState = null;
        for (class_2350 flowDirection : DirectionConstants.HORIZONTAL) {
            class_2680 flowTargetBlock;
            class_2338 flowTargetPos = pos.method_10093(flowDirection);
            byte blockIndex = FlowingFluidMixin.indexFromDiamondXZOffset(pos, flowTargetPos, searchRadius);
            blockStateCache[blockIndex] = flowTargetBlock = world.method_8320(flowTargetPos);
            if (!this.canMaybeFlowIntoBlock((class_1937)world, flowTargetBlock, flowTargetPos)) continue;
            if (onlyPossibleFlowDirection == null) {
                onlyPossibleFlowDirection = flowDirection;
                onlyBlockPos = flowTargetPos;
                onlyBlockState = flowTargetBlock;
                continue;
            }
            this.calculateComplexFluidFlowDirections(world, pos, state, blockStateCache, flowResultByDirection);
            cir.setReturnValue((Object)flowResultByDirection);
            return;
        }
        if (onlyPossibleFlowDirection != null && this.method_61813((class_1922)world, pos, state, onlyPossibleFlowDirection, onlyBlockPos, onlyBlockState, onlyFluidState = onlyBlockState.method_26227()) && FlowingFluidMixin.method_61815((class_1922)world, onlyBlockPos, onlyBlockState, (targetNewFluidState = this.method_15727(world, onlyBlockPos, onlyBlockState)).method_15772()) && onlyFluidState.method_15764((class_1922)world, onlyBlockPos, targetNewFluidState.method_15772(), onlyPossibleFlowDirection)) {
            flowResultByDirection.put(onlyPossibleFlowDirection, targetNewFluidState);
        }
        cir.setReturnValue((Object)flowResultByDirection);
    }

    @Overwrite
    private boolean method_15746(class_1922 world, class_3611 fluid, class_2338 pos, class_2680 state, class_2350 face, class_2338 fromPos, class_2680 fromState, class_3610 fluidState) {
        return FlowingFluidMixin.method_61815(world, fromPos, fromState, fluid) && this.method_61813(world, pos, state, face, fromPos, fromState, fluidState);
    }

    @Overwrite
    public boolean method_15736(class_1922 world, class_2338 pos, class_2680 state, class_2338 fromPos, class_2680 fromState) {
        return (fromState.method_26227().method_15772().method_15780((class_3611)this) || FlowingFluidMixin.method_15754(world, fromPos, fromState, this.method_15750())) && FlowingFluidMixin.method_15732(class_2350.field_11033, world, pos, state, fromPos, fromState);
    }

    @Unique
    private class_2680 getBlock(class_1937 world, class_2338 pos, class_2680[] blockStateCache, int key) {
        class_2680 blockState = blockStateCache[key];
        if (blockState == null) {
            blockStateCache[key] = blockState = world.method_8320(pos);
        }
        return blockState;
    }

    @Unique
    private void removeDirectionsWithoutHoleAccess(byte holeAccess, Map<class_2350, class_3610> flowResultByDirection) {
        for (int i = 0; i < DirectionConstants.HORIZONTAL.length; ++i) {
            if ((holeAccess & 1 << i) != 0) continue;
            flowResultByDirection.remove(DirectionConstants.HORIZONTAL[i]);
        }
    }

    @Unique
    private boolean canMaybeFlowIntoBlock(class_1937 world, class_2680 blockState, class_2338 flowTargetPos) {
        return FlowingFluidMixin.method_15754((class_1922)world, flowTargetPos, blockState, this.method_15751());
    }

    @Unique
    private void calculateComplexFluidFlowDirections(class_3218 world, class_2338 startPos, class_2680 startState, class_2680[] blockStateCache, Map<class_2350, class_3610> flowResultByDirection) {
        int i;
        Byte2ByteOpenHashMap prevPositions = new Byte2ByteOpenHashMap();
        Byte2ByteOpenHashMap currentPositions = new Byte2ByteOpenHashMap();
        Byte2BooleanOpenHashMap holeCache = new Byte2BooleanOpenHashMap();
        byte holeAccess = 0;
        int searchRadius = this.method_15733((class_4538)world) + 1;
        for (i = 0; i < DirectionConstants.HORIZONTAL.length; ++i) {
            class_3610 targetNewFluidState;
            byte blockIndex;
            class_2680 targetBlockState;
            class_2350 flowDirection = DirectionConstants.HORIZONTAL[i];
            class_2338 flowTargetPos = startPos.method_10093(flowDirection);
            if (!this.method_61813((class_1922)world, startPos, startState, flowDirection, flowTargetPos, targetBlockState = this.getBlock((class_1937)world, flowTargetPos, blockStateCache, blockIndex = FlowingFluidMixin.indexFromDiamondXZOffset(startPos, flowTargetPos, searchRadius)), targetBlockState.method_26227()) || !FlowingFluidMixin.method_61815((class_1922)world, flowTargetPos, targetBlockState, (targetNewFluidState = this.method_15727(world, flowTargetPos, targetBlockState)).method_15772())) continue;
            if (targetBlockState.method_26227().method_15764((class_1922)world, flowTargetPos, targetNewFluidState.method_15772(), flowDirection)) {
                flowResultByDirection.put(flowDirection, targetNewFluidState);
            }
            if (!this.method_15746((class_1922)world, targetNewFluidState.method_15772(), startPos, startState, flowDirection, flowTargetPos, targetBlockState, targetBlockState.method_26227())) continue;
            prevPositions.put(blockIndex, (byte)(17 << i));
            if (!this.isHoleBelow((class_4538)world, holeCache, blockIndex, flowTargetPos, targetBlockState)) continue;
            holeAccess = (byte)(holeAccess | (byte)(1 << i));
        }
        for (i = 0; i < this.method_15733((class_4538)world) && holeAccess == 0; ++i) {
            class_3611 targetFluid = this.method_15750();
            ObjectIterator iterator = prevPositions.byte2ByteEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Byte2ByteMap.Entry entry = (Byte2ByteMap.Entry)iterator.next();
                byte blockIndex = entry.getByteKey();
                byte currentInfo = entry.getByteValue();
                int rowLength = 2 * searchRadius + 1;
                int row = blockIndex / rowLength;
                int column = blockIndex % rowLength;
                int unevenColumn = column % 2;
                int xOffset = (row * 2 + column + unevenColumn - searchRadius * 2) / 2;
                int zOffset = xOffset - column + searchRadius;
                class_2338 currentPos = startPos.method_10069(xOffset, 0, zOffset);
                class_2680 currentState = blockStateCache[blockIndex];
                for (int j = 0; j < DirectionConstants.HORIZONTAL.length; ++j) {
                    byte oldInfo;
                    class_2338 flowTargetPos;
                    byte targetPosBlockIndex;
                    class_2350 flowDirection = DirectionConstants.HORIZONTAL[j];
                    byte oppositeDirection = DirectionConstants.HORIZONTAL_OPPOSITE_INDICES[j];
                    if ((currentInfo >> 4 & 1 << oppositeDirection) != 0 || prevPositions.containsKey(targetPosBlockIndex = FlowingFluidMixin.indexFromDiamondXZOffset(startPos, flowTargetPos = currentPos.method_10093(flowDirection), searchRadius))) continue;
                    byte newInfo = oldInfo = currentPositions.getOrDefault(targetPosBlockIndex, (byte)0);
                    newInfo = (byte)(newInfo | (byte)(16 << j));
                    if (((newInfo = (byte)(newInfo | (byte)(currentInfo & 0xF))) & 0xF) == (oldInfo & 0xF)) {
                        currentPositions.put(targetPosBlockIndex, newInfo);
                        continue;
                    }
                    class_2680 targetBlockState = this.getBlock((class_1937)world, flowTargetPos, blockStateCache, targetPosBlockIndex);
                    if (!this.method_15746((class_1922)world, targetFluid, currentPos, currentState, flowDirection, flowTargetPos, targetBlockState, targetBlockState.method_26227())) continue;
                    currentPositions.put(targetPosBlockIndex, newInfo);
                    if (!this.isHoleBelow((class_4538)world, holeCache, targetPosBlockIndex, flowTargetPos, targetBlockState)) continue;
                    holeAccess = (byte)(holeAccess | (byte)(currentInfo & 0xF));
                }
            }
            Byte2ByteOpenHashMap tmp = prevPositions;
            prevPositions = currentPositions;
            currentPositions = tmp;
            currentPositions.clear();
        }
        if (holeAccess != 0) {
            this.removeDirectionsWithoutHoleAccess(holeAccess, flowResultByDirection);
        }
    }

    @Unique
    private boolean isHoleBelow(class_4538 world, Byte2BooleanOpenHashMap holeCache, byte key, class_2338 flowTargetPos, class_2680 targetBlockState) {
        if (holeCache.get(key)) {
            return true;
        }
        class_2338 downPos = flowTargetPos.method_10074();
        class_2680 downBlock = world.method_8320(downPos);
        boolean holeFound = this.method_15736((class_1922)world, flowTargetPos, targetBlockState, downPos, downBlock);
        holeCache.put(key, holeFound);
        return holeFound;
    }
}

