/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import com.mojang.serialization.Codec;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class ErodedPillarFeature
extends class_3031<class_3111> {
    private static final int BASE_RADIUS = 8;
    private static final int PEAK_MIN_RADIUS = 3;

    public ErodedPillarFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_2338 pos = context.method_33655();
        class_5281 level = context.method_33652();
        class_5819 random = context.method_33654();
        int width = 8;
        int height = random.method_43048(15) + 50;
        if (random.method_43058() > 0.9) {
            height += random.method_43048(19) + 7;
        }
        int radius = Math.min(height + random.method_43048(7) - random.method_43048(5), width);
        for (int x = -width; x < width; ++x) {
            for (int z = -width; z < width; ++z) {
                for (int y = 0; y < height; ++y) {
                    int k2 = this.heightDependentRadiusSteep(random, y, height, radius);
                    if (x >= k2) continue;
                    this.generateBlock((class_1936)level, random, pos, height, x, y, z, k2);
                }
            }
        }
        this.smooth((class_1936)level, pos, radius + 3, height);
        return true;
    }

    private void generateBlock(class_1936 level, class_5819 random, class_2338 origin, int pillarHeight, int xOffset, int yOffset, int zOffset, int radius) {
        double distance = this.signedDistanceCircle(xOffset, zOffset, class_2338.field_10980, radius, random);
        if (distance < 0.0) {
            class_2338 pos = origin.method_10069(xOffset, yOffset, zOffset);
            double discardThreshold = -6 - random.method_43048(3);
            if (distance > discardThreshold && random.method_43058() > 0.9) {
                return;
            }
            this.setPillarBlock(pos, level, random, pillarHeight - yOffset, pillarHeight);
        }
    }

    private void setPillarBlock(class_2338 pos, class_1936 level, class_5819 random, int heightFromTop, int height) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26215() || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10340) || state.method_27852(class_2246.field_10382)) {
            if (level.method_8320(pos.method_10074()).method_27852(class_2246.field_10219)) {
                this.method_13153((class_1945)level, pos.method_10074(), class_2246.field_10566.method_9564());
            }
            if (heightFromTop <= random.method_43048((int)((double)height * 0.6))) {
                this.method_13153((class_1945)level, pos, class_2246.field_10219.method_9564());
            } else {
                this.method_13153((class_1945)level, pos, class_2246.field_10340.method_9564());
            }
        }
    }

    private double signedDistanceCircle(int p_225089_, int p_225090_, class_2338 p_225091_, int p_225092_, class_5819 p_225093_) {
        float f = 10.0f * class_3532.method_15363((float)p_225093_.method_43057(), (float)0.2f, (float)0.8f) / (float)p_225092_;
        return (double)f + Math.pow(p_225089_ - p_225091_.method_10263(), 2.0) + Math.pow(p_225090_ - p_225091_.method_10260(), 2.0) - Math.pow(p_225092_, 2.0);
    }

    private int heightDependentRadiusSteep(class_5819 random, int height, int maxHeight, int baseRadius) {
        float randomScale = 1.0f + random.method_43057() / 2.0f;
        float f1 = (1.0f - (float)height / ((float)maxHeight * randomScale)) * (float)baseRadius;
        return class_3532.method_15386((float)(f1 / 2.0f)) + 3;
    }

    private static boolean isPillarState(class_2680 state) {
        return state.method_27852(class_2246.field_10340) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10219);
    }

    private boolean belowIsAir(class_1922 p_66046_, class_2338 p_66047_) {
        return p_66046_.method_8320(p_66047_.method_10074()).method_26215();
    }

    private void smooth(class_1936 level, class_2338 pos, int radius, int height) {
        int i = radius / 2;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                for (int l = 0; l <= height; ++l) {
                    class_2338 blockpos = pos.method_10069(j, l, k);
                    class_2680 blockstate = level.method_8320(blockpos);
                    if (!ErodedPillarFeature.isPillarState(blockstate)) continue;
                    if (this.belowIsAir((class_1922)level, blockpos)) {
                        this.method_13153((class_1945)level, blockpos, class_2246.field_10124.method_9564());
                        this.method_13153((class_1945)level, blockpos.method_10084(), class_2246.field_10124.method_9564());
                        continue;
                    }
                    if (!ErodedPillarFeature.isPillarState(blockstate)) continue;
                    class_2680[] ablockstate = new class_2680[]{level.method_8320(blockpos.method_10067()), level.method_8320(blockpos.method_10078()), level.method_8320(blockpos.method_10095()), level.method_8320(blockpos.method_10072())};
                    int i1 = 0;
                    for (class_2680 blockstate1 : ablockstate) {
                        if (ErodedPillarFeature.isPillarState(blockstate1)) continue;
                        ++i1;
                    }
                    if (i1 < 3) continue;
                    this.method_13153((class_1945)level, blockpos, class_2246.field_10124.method_9564());
                }
            }
        }
    }
}

