/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.render;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.client.render.frapi.wrapper.ExtendedMutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.wrapper.MutableQuadViewWrapper;
import net.caffeinemc.mods.sodium.client.render.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.model.AbstractRenderContext;
import net.caffeinemc.mods.sodium.client.render.model.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.model.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.model.QuadEncoder;
import net.caffeinemc.mods.sodium.client.render.model.SodiumQuadAtlas;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteFinderCache;
import net.caffeinemc.mods.sodium.mixin.frapi.ItemRendererAccessor;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadAtlas;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.ItemRenderTypeGetter;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_777;
import net.minecraft.class_7837;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.jspecify.annotations.Nullable;

public class ItemRenderContext
extends AbstractRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private static final int GLINT_COUNT = class_10444.class_10445.values().length;
    private @Nullable ItemRenderTypeGetter renderTypeGetter;
    private final MutableQuadViewImpl editorQuad = new ItemEmitter();
    private final class_5819 random = new class_6575(42L);
    private final Supplier<class_5819> randomSupplier = () -> {
        this.random.method_43052(42L);
        return this.random;
    };
    private class_811 transformMode;
    private class_4587 poseStack;
    private Matrix4f matPosition;
    private boolean trustedNormals;
    private Matrix3f matNormal;
    private class_4597 bufferSource;
    private int lightmap;
    private int overlay;
    private int[] colors;
    private boolean ignoreQuadGlint;
    private class_1921 defaultLayer;
    private class_10444.class_10445 defaultGlint;
    private class_4587.class_4665 specialGlintEntry;
    private final class_4588[] vertexConsumerCache = new class_4588[3 * GLINT_COUNT];

    @Override
    public MutableQuadViewImpl getForEmitting() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public void renderItem(class_811 displayContext, class_4587 poseStack, class_4597 bufferSource, int lightmap, int overlay, int[] colors, List<class_777> vanillaQuads, MeshView mesh, class_1921 layer, class_10444.class_10445 glint, @Nullable ItemRenderTypeGetter renderTypeGetter, boolean ignoreQuadGlint) {
        this.transformMode = displayContext;
        this.matPosition = poseStack.method_23760().method_23761();
        this.poseStack = poseStack;
        this.trustedNormals = this.poseStack.method_23760().field_48930;
        this.matNormal = this.poseStack.method_23760().method_23762();
        this.bufferSource = bufferSource;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.colors = colors;
        this.ignoreQuadGlint = ignoreQuadGlint;
        this.renderTypeGetter = renderTypeGetter;
        this.defaultLayer = layer;
        this.defaultGlint = glint;
        this.bufferQuads(vanillaQuads, mesh);
        this.poseStack = null;
        this.bufferSource = null;
        this.colors = null;
        this.renderTypeGetter = null;
        this.specialGlintEntry = null;
        Arrays.fill(this.vertexConsumerCache, null);
    }

    private void bufferQuads(List<class_777> vanillaQuads, MeshView mesh) {
        MutableQuadViewWrapper emitter = ((ExtendedMutableQuadViewImpl)((Object)this.getForEmitting())).getWrapper();
        int vanillaQuadCount = vanillaQuads.size();
        for (int j = 0; j < vanillaQuadCount; ++j) {
            class_777 q = vanillaQuads.get(j);
            emitter.fromBakedQuad(q);
            emitter.emit();
        }
        mesh.outputTo((QuadEmitter)emitter);
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        boolean emissive = quad.emissive();
        class_4588 vertexConsumer = this.getVertexConsumer(quad.getQuadAtlas(), quad.getRenderType(), quad.glint());
        this.tintQuad(quad);
        this.shadeQuad(quad, emissive);
        this.bufferQuad(quad, vertexConsumer, quad.getQuadAtlas() == SodiumQuadAtlas.ITEM);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.getTintIndex();
        if (tintIndex != -1 && tintIndex < this.colors.length) {
            int color = this.colors[tintIndex];
            for (int i = 0; i < 4; ++i) {
                quad.setColor(i, ColorMixer.mulComponentWise(color, quad.baseColor(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.setLight(i, 0xF000F0);
            }
        } else {
            int lightmap = this.lightmap;
            for (int i = 0; i < 4; ++i) {
                quad.setLight(i, ColorHelper.maxBrightness(quad.getLight(i), lightmap));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, class_4588 vertexConsumer, boolean wasItemAtlas) {
        QuadEncoder.writeQuadVertices(quad, vertexConsumer, this.overlay, this.matPosition, this.trustedNormals, this.matNormal);
        class_1058 sprite = quad.sprite(wasItemAtlas ? SpriteFinderCache.forItemAtlas() : SpriteFinderCache.forBlockAtlas());
        if (sprite != null) {
            SpriteUtil.INSTANCE.markSpriteActive(sprite);
        }
    }

    private class_4588 getVertexConsumer(SodiumQuadAtlas quadAtlas, @Nullable class_11515 quadRenderLayer, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_10444.class_10445 quadGlint) {
        class_1921 layer;
        if (this.renderTypeGetter != null) {
            layer = this.renderTypeGetter.renderType(quadAtlas == SodiumQuadAtlas.BLOCK ? QuadAtlas.BLOCK : QuadAtlas.ITEM, quadRenderLayer);
            if (layer == null) {
                layer = this.defaultLayer;
            }
        } else {
            layer = this.defaultLayer;
        }
        class_10444.class_10445 glint = this.ignoreQuadGlint || quadGlint == null ? this.defaultGlint : quadGlint;
        if (layer == class_4722.method_29382()) {
            cacheIndex = 0;
        } else if (layer == class_4722.method_24074()) {
            cacheIndex = GLINT_COUNT;
        } else if (layer == class_4722.method_76545()) {
            cacheIndex = 2 * GLINT_COUNT;
        } else {
            return this.createVertexConsumer(layer, glint);
        }
        class_4588 vertexConsumer = this.vertexConsumerCache[cacheIndex += glint.ordinal()];
        if (vertexConsumer == null) {
            this.vertexConsumerCache[cacheIndex] = vertexConsumer = this.createVertexConsumer(layer, glint);
        }
        return vertexConsumer;
    }

    private class_4588 createVertexConsumer(class_1921 type, class_10444.class_10445 glint) {
        if (glint == class_10444.class_10445.field_55343) {
            if (this.specialGlintEntry == null) {
                this.specialGlintEntry = this.poseStack.method_23760().method_56822();
                if (this.transformMode == class_811.field_4317) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.5f);
                } else if (this.transformMode.method_29998()) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.75f);
                }
            }
            return ItemRendererAccessor.sodium$getSpecialFoilBuffer(this.bufferSource, type, this.specialGlintEntry);
        }
        return class_918.method_23181((class_4597)this.bufferSource, (class_1921)type, (boolean)true, (glint != class_10444.class_10445.field_55341 ? 1 : 0) != 0);
    }

    public class ItemEmitter
    extends MutableQuadViewImpl {
        public ItemEmitter() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            ItemRenderContext.this.renderQuad(this);
        }
    }

    @FunctionalInterface
    public static interface VanillaModelBufferer {
        public void accept(class_1087 var1, int[] var2, int var3, int var4, class_4587 var5, class_4588 var6);
    }
}

