/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.IConfigTable;
import fi.dy.masa.malilib.config.options.table.Label;
import fi.dy.masa.malilib.config.options.table.TableRow;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.interfaces.IConfigGui;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.widgets.WidgetListTableEdit;
import fi.dy.masa.malilib.gui.widgets.WidgetTableEditEntry;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.class_11908;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class GuiTableEdit
extends GuiListBase<TableRow, WidgetTableEditEntry, WidgetListTableEdit> {
    protected final IConfigTable config;
    protected final IConfigGui configGui;
    protected int dialogWidth;
    protected int dialogHeight;
    protected int dialogLeft;
    protected int dialogTop;
    @Nullable
    protected final IDialogHandler dialogHandler;

    public GuiTableEdit(IConfigTable config, IConfigGui configGui, @Nullable IDialogHandler dialogHandler, class_437 parent) {
        super(0, 0);
        this.config = config;
        this.configGui = configGui;
        this.dialogHandler = dialogHandler;
        this.title = StringUtils.translate("malilib.gui.title.table_edit", config.getName());
        if (this.dialogHandler == null) {
            this.setParent(parent);
        }
    }

    protected void setWidthAndHeight() {
        this.dialogWidth = GuiUtils.getScaledWindowWidth() - 100;
        this.dialogHeight = GuiUtils.getScaledWindowHeight() - 90;
    }

    protected void centerOnScreen() {
        if (this.getParent() != null) {
            this.dialogLeft = this.getParent().field_22789 / 2 - this.dialogWidth / 2;
            this.dialogTop = this.getParent().field_22790 / 2 - this.dialogHeight / 2;
        } else {
            this.dialogLeft = 20;
            this.dialogTop = 20;
        }
    }

    @Override
    public void initGui() {
        this.setWidthAndHeight();
        this.centerOnScreen();
        this.reCreateListWidget();
        super.initGui();
    }

    public IConfigTable getConfig() {
        return this.config;
    }

    @Override
    protected int getBrowserWidth() {
        return this.dialogWidth - 14;
    }

    @Override
    protected int getBrowserHeight() {
        return this.dialogHeight - 40;
    }

    @Override
    protected WidgetListTableEdit createListWidget(int listX, int listY) {
        return new WidgetListTableEdit(this.dialogLeft + 10, this.dialogTop + 30, this.getBrowserWidth(), this.getBrowserHeight(), this.dialogWidth - 100, this);
    }

    @Override
    public void method_25432() {
        if (this.getListWidget() != null && ((WidgetListTableEdit)this.getListWidget()).wereConfigsModified()) {
            ((WidgetListTableEdit)this.getListWidget()).applyPendingModifications();
            ConfigManager.getInstance().onConfigsChanged(this.configGui.getModId());
        }
        super.method_25432();
    }

    @Override
    public void method_25394(@NotNull class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().method_25394(drawContext, mouseX, mouseY, partialTicks);
        }
        super.method_25394(drawContext, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void drawScreenBackground(GuiContext ctx, int mouseX, int mouseY) {
        RenderUtils.drawOutlinedBox(ctx, this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -16777216, -6710887);
    }

    @Override
    protected void drawTitle(GuiContext ctx, int mouseX, int mouseY, float partialTicks) {
        this.drawStringWithShadow(ctx, this.title, this.dialogLeft + 10, this.dialogTop + 6, -1);
        for (int i = 0; i < this.config.getLabels().size(); ++i) {
            Label label = this.config.getLabels().get(i);
            int x = this.dialogLeft + 18;
            if (this.config.showEntryNumbers()) {
                x += 15;
            }
            x = this.config.allowNewEntry() ? x + i * ((this.dialogWidth - 170) / this.config.getTypes().size()) + 2 : x + i * ((this.dialogWidth - 130) / this.config.getTypes().size()) + 2;
            this.drawStringWithShadow(ctx, label.label(), x, this.dialogTop + 25, -1);
            int labelWidth = ctx.fontRenderer().method_1727(label.label());
            int leniency = 2;
            int minLabelX = x - 2;
            int maxLabelX = x + labelWidth + 2;
            int minLabelY = this.dialogTop + 25 - 2;
            Objects.requireNonNull(ctx.fontRenderer());
            int maxLabelY = minLabelY + 9 + 2;
            if (label.comment().isEmpty() || mouseX < minLabelX || mouseX > maxLabelX || mouseY < minLabelY || mouseY > maxLabelY) continue;
            RenderUtils.drawHoverText(ctx, mouseX, mouseY, Collections.singletonList(label.comment()));
        }
    }

    @Override
    public boolean onKeyTyped(class_11908 input) {
        if (input.comp_4795() == 256 && this.dialogHandler != null) {
            this.dialogHandler.closeDialog();
            return true;
        }
        return super.onKeyTyped(input);
    }
}

