/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import org.apache.commons.lang3.ArrayUtils;
import xaero.lib.common.gui.widget.TooltipInfo;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.extensions.XaeroPlusSettingEntry;
import xaeroplus.settings.SettingHooks;
import xaeroplus.settings.TranslatableSettingEnum;
import xaeroplus.settings.XaeroPlusSetting;

public class EnumSetting<T extends Enum<T>>
extends XaeroPlusSetting {
    private final T[] enumValues;
    private T value;
    private Consumer<T> settingChangeConsumer;

    private EnumSetting(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, class_304 keyBinding, T[] enumValues, T defaultValue, Consumer<T> settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        super(settingName, settingNameTranslationKey, tooltipTranslationKey, keyBinding, visibilitySupplier);
        this.enumValues = enumValues;
        this.value = defaultValue;
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public static <E extends Enum<E>> EnumSetting<E> create(String settingName, String settingNameTranslationKey, E[] values, E defaultValue) {
        return new EnumSetting("[XP] " + settingName, settingNameTranslationKey, EnumSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, values, defaultValue, null, null);
    }

    public static <E extends Enum<E>> EnumSetting<E> create(String settingName, String settingNameTranslationKey, E[] values, E defaultValue, Consumer<E> settingChangeConsumer) {
        return new EnumSetting("[XP] " + settingName, settingNameTranslationKey, EnumSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, values, defaultValue, settingChangeConsumer, null);
    }

    public static <E extends Enum<E>> EnumSetting<E> create(String settingName, String settingNameTranslationKey, E[] values, E defaultValue, Consumer<E> settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        return new EnumSetting("[XP] " + settingName, settingNameTranslationKey, EnumSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, values, defaultValue, settingChangeConsumer, visibilitySupplier);
    }

    @Override
    public String getSerializedValue() {
        return Integer.toString(this.getValueIndex());
    }

    @Override
    public void deserializeValue(String value) {
        int index = Integer.parseInt(value);
        if (index != this.getValueIndex()) {
            this.setValueIndex(index);
        }
    }

    @Override
    public XaeroPlusSettingEntry<?> toXaeroSettingEntry() {
        return new XaeroPlusSettingEntry<Enum>(this, (class_2561)class_2561.method_43470((String)this.getTranslatedName()), new TooltipInfo(this.getTooltipTranslationKey()), false, this::get, 0, this.getIndexMax(), v -> this.getEnumValues()[v], v -> {
            if (v instanceof TranslatableSettingEnum) {
                TranslatableSettingEnum translatableSettingEnum = (TranslatableSettingEnum)((Object)v);
                return class_2561.method_43471((String)translatableSettingEnum.getTranslationKey());
            }
            return class_2561.method_43470((String)v.toString());
        }, (v1, v2) -> {
            this.setValue(v2);
            SettingHooks.saveSettings();
            class_310.method_1551().method_1507(class_310.method_1551().field_1755);
        }, this::isVisible);
    }

    public T get() {
        return this.value;
    }

    public void setValue(T newVal) {
        this.value = newVal;
        if (Objects.nonNull(this.getSettingChangeConsumer())) {
            try {
                this.getSettingChangeConsumer().accept(newVal);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Error applying setting change consumer for setting: {}, value: {}", new Object[]{this.getSettingName(), newVal, e});
            }
        }
    }

    public int getValueIndex() {
        return ArrayUtils.indexOf((Object[])this.enumValues, this.get());
    }

    public void setValueIndex(int index) {
        try {
            this.setValue(this.enumValues[index]);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Unable to set enum value setting for {}, index {}", new Object[]{this.getSettingName(), index, e});
        }
    }

    public int getIndexMax() {
        return this.enumValues.length - 1;
    }

    public void setSettingChangeConsumer(Consumer<T> settingChangeConsumer) {
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public Consumer<T> getSettingChangeConsumer() {
        return this.settingChangeConsumer;
    }

    public T[] getEnumValues() {
        return this.enumValues;
    }

    @Override
    public void init() {
        if (Objects.nonNull(this.settingChangeConsumer)) {
            this.settingChangeConsumer.accept(this.value);
        }
    }
}

