/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.justmobheads_common_forge.functions.JmhCommandFunctions;
import com.natamus.justmobheads_common_forge.util.HeadData;
import com.natamus.justmobheads_common_forge.util.MobHeads;
import com.natamus.justmobheads_common_forge.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.world.item.ItemStack;

public class CommandJmh {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"jmh").requires(iCommandSender -> iCommandSender.permissions().hasPermission(Permissions.COMMANDS_ADMIN))).then(Commands.literal((String)"reload").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Reloading head chances config file now.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            try {
                if (Util.generateChanceConfig(HeadData.defaultHeadChances)) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Succesfully loaded! The dropchances have been altered.", (ChatFormatting)ChatFormatting.DARK_GREEN);
                } else {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Generated new config file. Using the default chances.", (ChatFormatting)ChatFormatting.DARK_GREEN);
                }
            }
            catch (Exception ex) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while loading the config file.", (ChatFormatting)ChatFormatting.RED);
            }
            return 1;
        }))).then(Commands.literal((String)"head").then(Commands.literal((String)"list").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"You can generate the following mob heads:", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" Usage: /jmh head <name> <amount>:", (ChatFormatting)ChatFormatting.DARK_GREEN);
            ArrayList<String> mobnames = new ArrayList<String>(HeadData.headTextureData.keySet());
            Collections.sort(mobnames);
            String mnstr = String.join((CharSequence)", ", mobnames);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)mnstr, (ChatFormatting)ChatFormatting.YELLOW);
            return 1;
        })))).then(Commands.literal((String)"head").then(Commands.argument((String)"mob-name", (ArgumentType)StringArgumentType.string()).suggests(JmhCommandFunctions.mobHeadSuggestions).executes(command -> CommandJmh.headCommand((CommandContext<CommandSourceStack>)command, 1))))).then(Commands.literal((String)"head").then(Commands.argument((String)"mob-name", (ArgumentType)StringArgumentType.string()).suggests(JmhCommandFunctions.mobHeadSuggestions).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(command -> CommandJmh.headCommand((CommandContext<CommandSourceStack>)command, IntegerArgumentType.getInteger((CommandContext)command, (String)"amount")))))));
    }

    private static int headCommand(CommandContext<CommandSourceStack> command, int amount) {
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        String mobname = StringArgumentType.getString(command, (String)"mob-name").toLowerCase();
        if (!HeadData.headTextureData.containsKey(mobname)) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The mobname '" + mobname + "' does not exist. You can get a list of all possible heads with:"), (ChatFormatting)ChatFormatting.RED);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" Usage: /jmh head list", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException ex) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
            return 1;
        }
        ItemStack headstack = MobHeads.getMobHead(mobname, amount);
        if (!player.getInventory().add(headstack)) {
            player.drop(headstack, false);
        }
        String s = "";
        if (amount > 1) {
            s = "s";
        }
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully generated " + amount + " " + StringFunctions.capitalizeFirst((String)mobname.replace("_", " ")) + " head" + s + "."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        return 1;
    }
}

