/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.fabric.event;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.fabric.common.wrapper.BlockBreakEventWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.BlockEntityWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.BlockPosWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.BlockStateWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.LevelWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.PlayerWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.ServerLevelWrapper;
import java.util.Optional;
import lombok.Generated;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jspecify.annotations.NonNull;

public class BlockBreakListener
implements PlayerBlockBreakEvents.Before,
PlayerBlockBreakEvents.After {
    private final @NonNull FallingTreeCommon<?> mod;

    public boolean beforeBlockBreak(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        LevelWrapper levelWrapper;
        PlayerWrapper wrappedPlayer = new PlayerWrapper(player);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            levelWrapper = new ServerLevelWrapper(serverLevel);
        } else {
            levelWrapper = new LevelWrapper(level);
        }
        LevelWrapper wrappedLevel = levelWrapper;
        BlockPosWrapper wrappedPos = new BlockPosWrapper(blockPos);
        BlockStateWrapper wrappedState = new BlockStateWrapper(blockState);
        BlockEntityWrapper wrappedEntity = Optional.ofNullable(blockEntity).map(BlockEntityWrapper::new).orElse(null);
        if (this.mod.isOwnEvent(new BlockBreakEventWrapper(blockPos))) {
            return true;
        }
        return !this.mod.getTreeHandler().shouldCancelEvent(wrappedLevel, wrappedPlayer, wrappedPos, wrappedState, wrappedEntity);
    }

    public void afterBlockBreak(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        LevelWrapper levelWrapper;
        PlayerWrapper wrappedPlayer = new PlayerWrapper(player);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            levelWrapper = new ServerLevelWrapper(serverLevel);
        } else {
            levelWrapper = new LevelWrapper(level);
        }
        LevelWrapper wrappedLevel = levelWrapper;
        BlockPosWrapper wrappedPos = new BlockPosWrapper(blockPos);
        BlockStateWrapper wrappedState = new BlockStateWrapper(blockState);
        BlockEntityWrapper wrappedEntity = Optional.ofNullable(blockEntity).map(BlockEntityWrapper::new).orElse(null);
        this.mod.getTreeHandler().breakTree(false, wrappedLevel, wrappedPlayer, wrappedPos, wrappedState, wrappedEntity);
    }

    @Generated
    public BlockBreakListener(@NonNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

