/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.common.wrapper;

import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ComponentWrapper;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BlockWrapper
implements IBlock {
    private final @NonNull Block raw;

    @Override
    public boolean isAir() {
        return Blocks.AIR.equals(this.raw);
    }

    @Override
    public void playerDestroy(@NonNull ILevel level, @NonNull IPlayer player, @NonNull IBlockPos blockPos, @NonNull IBlockState blockState, @Nullable IBlockEntity blockEntity, @NonNull IItemStack itemStack, boolean dropResources) {
        BlockEntity entity = blockEntity == null ? null : (BlockEntity)blockEntity.getRaw();
        Player realPlayer = (Player)player.getRaw();
        realPlayer.awardStat(Stats.BLOCK_MINED.get((Object)this.raw));
        realPlayer.causeFoodExhaustion(0.005f);
        if (dropResources) {
            Block.dropResources((BlockState)((BlockState)blockState.getRaw()), (Level)((Level)level.getRaw()), (BlockPos)((BlockPos)blockPos.getRaw()), (BlockEntity)entity, (Entity)realPlayer, (ItemStack)((ItemStack)itemStack.getRaw()));
        }
    }

    @Override
    public @NonNull IComponent getAsComponent() {
        return new ComponentWrapper(this.raw.getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IBlock)) {
            return false;
        }
        IBlock block = (IBlock)obj;
        return this.raw.equals(block.getRaw());
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    @Generated
    public BlockWrapper(@NonNull Block raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    @Generated
    public String toString() {
        return "BlockWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @Generated
    public @NonNull Block getRaw() {
        return this.raw;
    }
}

