/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.functions.HeadFunctions;
import com.natamus.justmobheads_common_forge.util.HeadData;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.WeatheringCopper;

public class MobHeads {
    static List<String> horsetypes = Arrays.asList("white", "creamy", "chestnut", "brown", "black", "gray", "dark_brown");
    static List<String> llamatypes = Arrays.asList("creamy", "white", "brown", "gray");
    static List<String> parrottypes = Arrays.asList("red", "blue", "green", "cyan", "gray");
    static List<String> rabbittypes = Arrays.asList("brown", "white", "black", "black_and_white", "gold", "salt_and_pepper");
    static List<String> cattypes = Arrays.asList("tabby", "tuxedo", "red", "siamese", "british_shorthair", "calico", "persian", "ragdoll", "white", "jellie", "black");
    static List<String> axolotltypes = Arrays.asList("lucy", "wild", "gold", "cyan", "blue");

    public static ItemStack getMobHead(String mobName, Integer amount) {
        Pair<String, String> textureData = HeadData.headTextureData.get(mobName);
        if (textureData == null) {
            return null;
        }
        String headNoteBlockSound = HeadData.headNoteBlockSounds.get(mobName) == null ? "" : HeadData.headNoteBlockSounds.get(mobName);
        String formattedMobName = MobHeads.capitalizeFirst(mobName.replace("_", " "));
        String oldid = (String)textureData.getFirst();
        String texture = (String)textureData.getSecond();
        ItemStack texturedHeadStack = HeadFunctions.getNewTexturedHead((String)mobName, (String)texture, (String)oldid, (String)headNoteBlockSound, (Integer)amount);
        texturedHeadStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)(formattedMobName + " Head")));
        return texturedHeadStack;
    }

    public static ItemStack getStandardHead(String headname) {
        String mob;
        ItemStack mobhead = new ItemStack((ItemLike)Items.PLAYER_HEAD, 1);
        switch (mob = headname.toLowerCase().split(" ")[0]) {
            case "creeper": {
                mobhead = new ItemStack((ItemLike)Items.CREEPER_HEAD, 1);
                break;
            }
            case "zombie": {
                mobhead = new ItemStack((ItemLike)Items.ZOMBIE_HEAD, 1);
                break;
            }
            case "skeleton": {
                mobhead = new ItemStack((ItemLike)Items.SKELETON_SKULL, 1);
            }
        }
        mobhead.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)headname));
        return mobhead;
    }

    public static String getName(Entity entity) {
        String entitystring = EntityFunctions.getEntityString((Entity)entity);
        Object mobname = entitystring.split("\\[")[0].replace("Entity", "");
        mobname = String.join((CharSequence)"_", ((String)mobname).split("(?<=.)(?=\\p{Lu})")).toLowerCase();
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Creeper.class, Cat.class, CopperGolem.class, Wolf.class, Horse.class, TraderLlama.class, Llama.class, Parrot.class, Rabbit.class, Sheep.class, MushroomCow.class, Fox.class, Axolotl.class, Frog.class, Chicken.class, Cow.class, Pig.class, Villager.class, ZombieVillager.class}, (Object)entity3, n)) {
            case 0: {
                Creeper creeper = (Creeper)entity3;
                if (!creeper.isPowered()) break;
                mobname = "charged_creeper";
                break;
            }
            case 1: {
                Cat cat = (Cat)entity3;
                CatVariant catVariant = (CatVariant)cat.getVariant().value();
                ResourceLocation texture = catVariant.assetInfo().texturePath();
                String type = texture.toString().split("cat/")[1].replace(".png", "");
                mobname = type + "_cat";
                break;
            }
            case 2: {
                CopperGolem copperGolem = (CopperGolem)entity3;
                WeatheringCopper.WeatherState weatherState = copperGolem.getWeatherState();
                Object weatherStateString = weatherState.name().toLowerCase();
                weatherStateString = ((String)weatherStateString).equals("unaffected") ? "" : (String)weatherStateString + "_";
                mobname = (String)weatherStateString + "copper_golem";
                break;
            }
            case 3: {
                Wolf wolf = (Wolf)entity3;
                ResourceLocation texture = wolf.getTexture();
                String type = texture.toString().split("wolf/")[1].replace(".png", "").replace("wolf_", "");
                mobname = type + "_wolf";
                break;
            }
            case 4: {
                Horse horse = (Horse)entity3;
                int type = horse.getVariant().getId();
                if (type >= 1024) {
                    type -= 1024;
                } else if (type >= 768) {
                    type -= 768;
                } else if (type >= 512) {
                    type -= 512;
                } else if (type >= 256) {
                    type -= 256;
                }
                mobname = horsetypes.get(type) + "_horse";
                break;
            }
            case 5: {
                TraderLlama traderllama = (TraderLlama)entity3;
                int type = traderllama.getVariant().getId();
                if (type >= llamatypes.size()) break;
                mobname = llamatypes.get(type) + "_trader_" + (String)mobname;
                break;
            }
            case 6: {
                Llama llama = (Llama)entity3;
                int type = llama.getVariant().getId();
                if (type >= llamatypes.size()) break;
                mobname = llamatypes.get(type) + "_" + (String)mobname;
                break;
            }
            case 7: {
                Parrot parrot = (Parrot)entity3;
                int type = parrot.getVariant().getId();
                if (type >= parrottypes.size()) break;
                mobname = parrottypes.get(type) + "_parrot";
                break;
            }
            case 8: {
                Rabbit rabbit = (Rabbit)entity3;
                int type = rabbit.getVariant().id();
                String rabbitname = rabbit.getDisplayName().getString();
                if (rabbitname.equals("Toast")) {
                    mobname = "toast_rabbit";
                    break;
                }
                if (type < rabbittypes.size()) {
                    mobname = rabbittypes.get(type) + "_rabbit";
                    break;
                }
                if (type != 99) break;
                mobname = "killer_rabbit";
                break;
            }
            case 9: {
                String name;
                Sheep sheep = (Sheep)entity3;
                boolean checktype = true;
                if (sheep.hasCustomName() && (name = sheep.getName().getString()).equals("jeb_")) {
                    mobname = "jeb_sheep";
                    checktype = false;
                }
                if (!checktype) break;
                DyeColor type = sheep.getColor();
                mobname = type.toString().toLowerCase() + "_sheep";
                break;
            }
            case 10: {
                MushroomCow mooshroom = (MushroomCow)entity3;
                if (mooshroom.getVariant() != MushroomCow.Variant.BROWN) break;
                mobname = "brown_mooshroom";
                break;
            }
            case 11: {
                Fox fox = (Fox)entity3;
                if (fox.getVariant() == Fox.Variant.SNOW) {
                    mobname = "snow_fox";
                    break;
                }
                mobname = "red_fox";
                break;
            }
            case 12: {
                Axolotl axolotl = (Axolotl)entity3;
                int type = axolotl.getVariant().getId();
                if (type >= axolotltypes.size()) break;
                mobname = axolotltypes.get(type) + "_axolotl";
                break;
            }
            case 13: {
                Frog frog = (Frog)entity3;
                Holder frogVariantHolder = frog.getVariant();
                if (frogVariantHolder.is(FrogVariants.WARM)) {
                    mobname = "warm_frog";
                    break;
                }
                if (frogVariantHolder.is(FrogVariants.COLD)) {
                    mobname = "cold_frog";
                    break;
                }
                if (!frogVariantHolder.is(FrogVariants.TEMPERATE)) break;
                mobname = "temperate_frog";
                break;
            }
            case 14: {
                Chicken chicken = (Chicken)entity3;
                Holder chickenVariantHolder = chicken.getVariant();
                if (chickenVariantHolder.is(ChickenVariants.WARM)) {
                    mobname = "warm_chicken";
                    break;
                }
                if (chickenVariantHolder.is(ChickenVariants.COLD)) {
                    mobname = "cold_chicken";
                    break;
                }
                if (!chickenVariantHolder.is(ChickenVariants.TEMPERATE)) break;
                mobname = "temperate_chicken";
                break;
            }
            case 15: {
                Cow cow = (Cow)entity3;
                Holder cowVariantHolder = cow.getVariant();
                if (cowVariantHolder.is(CowVariants.WARM)) {
                    mobname = "warm_cow";
                    break;
                }
                if (cowVariantHolder.is(CowVariants.COLD)) {
                    mobname = "cold_cow";
                    break;
                }
                if (!cowVariantHolder.is(CowVariants.TEMPERATE)) break;
                mobname = "temperate_cow";
                break;
            }
            case 16: {
                Pig pig = (Pig)entity3;
                Holder pigVariantHolder = pig.getVariant();
                if (pigVariantHolder.is(PigVariants.WARM)) {
                    mobname = "warm_pig";
                    break;
                }
                if (pigVariantHolder.is(PigVariants.COLD)) {
                    mobname = "cold_pig";
                    break;
                }
                if (!pigVariantHolder.is(PigVariants.TEMPERATE)) break;
                mobname = "temperate_pig";
                break;
            }
            case 17: {
                Villager villager = (Villager)entity3;
                VillagerData d = villager.getVillagerData();
                VillagerProfession prof = (VillagerProfession)d.profession().value();
                if (prof.toString().equals("none")) break;
                mobname = prof.toString();
                break;
            }
            case 18: {
                ZombieVillager zombievillager = (ZombieVillager)entity3;
                VillagerData d = zombievillager.getVillagerData();
                VillagerProfession prof = (VillagerProfession)d.profession().value();
                if (prof.toString().equals("none")) break;
                mobname = "zombie_" + String.valueOf(prof);
                break;
            }
        }
        return ((String)mobname).toLowerCase();
    }

    public static String capitalizeFirst(String string) {
        StringBuilder sb = new StringBuilder(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }
}

