/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.layout;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_768;

@Environment(value=EnvType.CLIENT)
public interface LayoutHelper {
    public static LayoutHelper centeredHorizontal(int itemCount, int rows, int width, int height, int spacing) {
        return new CenteredHorizontalLayoutHelper(itemCount, rows, width, height, spacing);
    }

    public int getX();

    public int getY();

    public void next();

    public int getTotalWidth();

    public int getTotalHeight();

    default public class_768 getArea() {
        int lWidth = this.getTotalWidth();
        int lHeight = this.getTotalHeight();
        return new class_768(-lWidth / 2, -lHeight / 2, lWidth, lHeight);
    }

    @Environment(value=EnvType.CLIENT)
    public static class CenteredHorizontalLayoutHelper
    implements LayoutHelper {
        int itemCount;
        int rows;
        int width;
        int height;
        int spacing;
        int currentColumn = 0;
        int currentRow = 0;
        int[] rowCounts;
        int x = 0;
        int y = 0;

        CenteredHorizontalLayoutHelper(int itemCount, int rows, int width, int height, int spacing) {
            this.itemCount = itemCount;
            this.rows = rows;
            this.width = width;
            this.height = height;
            this.spacing = spacing;
            this.rowCounts = new int[rows];
            int itemsPerRow = itemCount / rows;
            int itemDiff = itemCount - itemsPerRow * rows;
            for (int i = 0; i < rows; ++i) {
                this.rowCounts[i] = itemsPerRow;
                if (itemDiff <= 0) continue;
                int n = i;
                this.rowCounts[n] = this.rowCounts[n] + 1;
                --itemDiff;
            }
            this.init();
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public void next() {
            ++this.currentColumn;
            if (this.currentColumn >= this.rowCounts[this.currentRow]) {
                if (++this.currentRow >= this.rows) {
                    this.x = 0;
                    this.y = 0;
                    return;
                }
                this.currentColumn = 0;
                this.prepareX();
                this.y += this.height + this.spacing;
                return;
            }
            this.x += this.width + this.spacing;
        }

        private void init() {
            this.prepareX();
            this.prepareY();
        }

        private void prepareX() {
            int rowWidth = this.rowCounts[this.currentRow] * this.width + (this.rowCounts[this.currentRow] - 1) * this.spacing;
            this.x = -(rowWidth / 2);
        }

        private void prepareY() {
            int totalHeight = this.rows * this.height + (this.rows > 1 ? (this.rows - 1) * this.spacing : 0);
            this.y = -(totalHeight / 2);
        }

        @Override
        public int getTotalWidth() {
            return this.rowCounts[0] * this.width + (this.rowCounts[0] - 1) * this.spacing;
        }

        @Override
        public int getTotalHeight() {
            return this.rows * this.height + (this.rows > 1 ? (this.rows - 1) * this.spacing : 0);
        }
    }
}

