/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.contraptionControls;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlock;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_1767;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5481;
import net.minecraft.class_761;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ContraptionControlsMovementRender
implements MovementRenderBehaviour {
    private static final ThreadLocal<Random> RANDOM = ThreadLocal.withInitial(Random::new);

    @Override
    public MovementRenderState getRenderState(class_243 camera, class_327 textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        int width;
        int actualWidth;
        boolean hideDescription;
        Object object = context.temporaryData;
        if (!(object instanceof ContraptionControlsMovement.ElevatorFloorSelection)) {
            return null;
        }
        ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)object;
        class_2680 blockState = context.state;
        if (!blockState.method_27852((class_2248)AllBlocks.CONTRAPTION_CONTROLS)) {
            return null;
        }
        class_2338 pos = context.localPos;
        ContraptionControlsMovementRenderState state = new ContraptionControlsMovementRenderState(pos);
        float flicker = RANDOM.get().nextFloat();
        class_2586 class_25862 = ClientContraption.getBlockEntityClientSide(context.contraption, pos);
        if (class_25862 instanceof ContraptionControlsBlockEntity) {
            ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)class_25862;
            state.buttondepth = -0.041666668f * cbe.button.getValue(AnimationTickHolder.getPartialTicks(renderWorld));
        }
        state.layer = class_1921.method_23577();
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)ContraptionControlsBlock.field_11177);
        state.button = CachedBuffers.partialFacing(AllPartialModels.CONTRAPTION_CONTROLS_BUTTON, blockState, facing.method_10153());
        state.light = class_761.method_23794((class_1920)renderWorld, (class_2338)pos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        String text = efs.currentShortName;
        String description = efs.currentLongName;
        class_243 position = context.position;
        float playerDistance = (float)(position == null ? 0.0 : camera.method_1025(position));
        boolean hideText = text.isBlank() || playerDistance > 100.0f;
        boolean bl = hideDescription = description.isBlank() || playerDistance > 20.0f;
        if (hideText && hideDescription) {
            return state;
        }
        state.upAngle = AngleHelper.rad(AngleHelper.horizontalAngle(facing));
        state.westAngle = AngleHelper.rad(67.5);
        Couple<Integer> couple = DyeHelper.getDyeColors(efs.targetYEqualsSelection ? class_1767.field_7952 : class_1767.field_7946);
        int brightColor = (Integer)couple.getFirst();
        int darkColor = (Integer)couple.getSecond();
        state.color = Color.mixColors(brightColor, darkColor, flicker / 4.0f) | 0xFF000000;
        state.offsetZ = state.buttondepth - 0.25f;
        if (!hideText) {
            state.shadowColor = Color.mixColors(darkColor, 0, 0.35f) | 0xFF000000;
            actualWidth = textRenderer.method_1727(text);
            width = Math.max(actualWidth, 12);
            state.textScale = 1.0f / (5.0f * ((float)width - 0.5f));
            state.textX = (float)Math.max(0, width - actualWidth) / 2.0f;
            state.textY = ((float)width - 8.0f) / 2.0f;
            state.text = class_2561.method_43470((String)text).method_30937();
        }
        if (!hideDescription) {
            actualWidth = textRenderer.method_1727(description);
            width = Math.max(actualWidth, 55);
            state.descriptionScale = 1.0f / (3.0f * ((float)width - 0.5f));
            state.descriptionX = (float)Math.max(0, width - actualWidth) / 2.0f;
            state.descriptionY = ((float)width - 8.0f) / 2.0f;
            state.description = class_2561.method_43470((String)description).method_30937();
        }
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ContraptionControlsMovementRenderState
    extends MovementRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer button;
        public int light;
        public class_1937 world;
        public Matrix4f worldMatrix4f;
        public float buttondepth;
        public float upAngle;
        public float westAngle;
        public float offsetZ;
        public class_5481 text;
        public class_5481 description;
        public float textScale;
        public float textX;
        public float textY;
        public float descriptionScale;
        public float descriptionX;
        public float descriptionY;
        public int color;
        public int shadowColor;

        public ContraptionControlsMovementRenderState(class_2338 pos) {
            super(pos);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.0f, this.buttondepth, 0.0f);
            queue.method_73483(matrices, this.layer, (class_11659.class_11660)this);
            matrices.method_22909();
            if (this.text != null || this.description != null) {
                matrices.method_49278((Quaternionfc)new Quaternionf().setAngleAxis(this.upAngle, 0.0f, 1.0f, 0.0f), 0.5f, 0.5f, 0.5f);
                matrices.method_46416(0.4f, 1.125f, 0.5f);
                matrices.method_22907((Quaternionfc)new Quaternionf().setAngleAxis(this.westAngle, -1.0f, 0.0f, 0.0f));
                if (this.text != null) {
                    matrices.method_22903();
                    matrices.method_46416(0.0f, 0.15f, this.offsetZ);
                    matrices.method_22905(this.textScale, -this.textScale, this.textScale);
                    queue.method_73478(matrices, this.textX, this.textY, this.text, false, class_327.class_6415.field_33993, 0xF000F0, this.color, 0, 0);
                    matrices.method_46416(0.5f, 0.5f, -0.0625f);
                    queue.method_73478(matrices, this.textX, this.textY, this.text, false, class_327.class_6415.field_33993, 0xF000F0, this.shadowColor, 0, 0);
                    matrices.method_22909();
                }
                if (this.description != null) {
                    matrices.method_22903();
                    matrices.method_46416(-0.0635f, 0.06f, this.offsetZ);
                    matrices.method_22905(this.descriptionScale, -this.descriptionScale, this.descriptionScale);
                    queue.method_73478(matrices, this.descriptionX, this.descriptionY, this.description, false, class_327.class_6415.field_33993, 0xF000F0, this.color, 0, 0);
                    matrices.method_22909();
                }
            }
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.button.light(this.light).useLevelLight((class_1920)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

