/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.flywheel;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.flywheel.FlywheelBlockEntity;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class FlywheelVisual
extends KineticBlockEntityVisual<FlywheelBlockEntity>
implements SimpleDynamicVisual {
    protected final RotatingInstance shaft;
    protected final TransformedInstance wheel;
    protected float lastAngle = Float.NaN;
    protected final Matrix4f baseTransform = new Matrix4f();

    public FlywheelVisual(VisualizationContext context, FlywheelBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        class_2350.class_2351 axis = this.rotationAxis();
        this.shaft = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT)).createInstance();
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setPosition((class_2382)this.getVisualPosition()).rotateToFace(axis).setChanged();
        this.wheel = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.FLYWHEEL)).createInstance();
        class_2350 align = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
        ((TransformedInstance)((TransformedInstance)this.wheel.translate((class_2382)this.getVisualPosition())).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, 1.0f, 0.0f, (float)align.method_10148(), (float)align.method_10164(), (float)align.method_10165()));
        this.baseTransform.set((Matrix4fc)this.wheel.pose);
        this.animate(blockEntity.angle);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTicks = ctx.partialTick();
        float speed = ((FlywheelBlockEntity)this.blockEntity).visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = ((FlywheelBlockEntity)this.blockEntity).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        ((TransformedInstance)this.wheel.setTransform((Matrix4fc)this.baseTransform).rotateY(AngleHelper.rad(angle)).uncenter()).setChanged();
    }

    @Override
    public void update(float pt) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.shaft, this.wheel);
    }

    @Override
    protected void _delete() {
        this.shaft.delete();
        this.wheel.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.shaft);
        consumer.accept(this.wheel);
    }
}

