/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.gauge;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlock;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlockEntity;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public abstract class GaugeVisual
extends ShaftVisual<GaugeBlockEntity>
implements SimpleDynamicVisual {
    protected final ArrayList<DialFace> faces = new ArrayList(2);
    protected final class_4587 ms = new class_4587();

    protected GaugeVisual(VisualizationContext context, GaugeBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        GaugeBlock gaugeBlock = (GaugeBlock)this.blockState.method_26204();
        Instancer<TransformedInstance> dialModel = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.GAUGE_DIAL));
        Instancer<TransformedInstance> headModel = this.getHeadModel();
        PoseTransformStack msr = TransformStack.of(this.ms);
        msr.translate((class_2382)this.getVisualPosition());
        float progress = class_3532.method_16439((float)AnimationTickHolder.getPartialTicks(), (float)blockEntity.prevDialState, (float)blockEntity.dialState);
        for (class_2350 facing : Iterate.directions) {
            if (!gaugeBlock.shouldRenderHeadOnFace(this.level, this.pos, this.blockState, facing)) continue;
            DialFace face = this.makeFace(facing, dialModel, headModel);
            this.faces.add(face);
            face.setupTransform(msr, progress);
        }
    }

    private DialFace makeFace(class_2350 face, Instancer<TransformedInstance> dialModel, Instancer<TransformedInstance> headModel) {
        return new DialFace(face, dialModel.createInstance(), headModel.createInstance());
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        if (class_3532.method_15347((float)((GaugeBlockEntity)this.blockEntity).prevDialState, (float)((GaugeBlockEntity)this.blockEntity).dialState)) {
            return;
        }
        float progress = class_3532.method_16439((float)ctx.partialTick(), (float)((GaugeBlockEntity)this.blockEntity).prevDialState, (float)((GaugeBlockEntity)this.blockEntity).dialState);
        PoseTransformStack msr = TransformStack.of(this.ms);
        for (DialFace faceEntry : this.faces) {
            faceEntry.updateTransform(msr, progress);
        }
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight((FlatLit[])this.faces.stream().flatMap(Couple::stream).toArray(FlatLit[]::new));
    }

    @Override
    protected void _delete() {
        super._delete();
        this.faces.forEach(DialFace::delete);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        for (DialFace face : this.faces) {
            face.forEach(consumer);
        }
    }

    protected abstract Instancer<TransformedInstance> getHeadModel();

    @Environment(value=EnvType.CLIENT)
    protected class DialFace
    extends Couple<TransformedInstance> {
        class_2350 face;

        public DialFace(class_2350 face, TransformedInstance first, TransformedInstance second) {
            super(first, second);
            this.face = face;
        }

        private void setupTransform(TransformStack<?> msr, float progress) {
            float dialPivot = 0.359375f;
            msr.pushPose();
            this.rotateToFace(msr);
            ((TransformedInstance)this.getSecond()).setTransform(GaugeVisual.this.ms).setChanged();
            ((TransformStack)((TransformStack)msr.translate(0.0f, dialPivot, dialPivot)).rotate((float)(1.5707963267948966 * (double)(-progress)), class_2350.field_11034)).translate(0.0f, -dialPivot, -dialPivot);
            ((TransformedInstance)this.getFirst()).setTransform(GaugeVisual.this.ms).setChanged();
            msr.popPose();
        }

        private void updateTransform(TransformStack<?> msr, float progress) {
            float dialPivot = 0.359375f;
            msr.pushPose();
            ((TransformStack)((TransformStack)this.rotateToFace(msr).translate(0.0f, dialPivot, dialPivot)).rotate((float)(1.5707963267948966 * (double)(-progress)), class_2350.field_11034)).translate(0.0f, -dialPivot, -dialPivot);
            ((TransformedInstance)this.getFirst()).setTransform(GaugeVisual.this.ms).setChanged();
            msr.popPose();
        }

        protected TransformStack<?> rotateToFace(TransformStack<?> msr) {
            return (TransformStack)((TransformStack)((TransformStack)msr.center()).rotate((float)((double)((-this.face.method_10144() - 90.0f) / 180.0f) * Math.PI), class_2350.field_11036)).uncenter();
        }

        private void delete() {
            ((TransformedInstance)this.getFirst()).delete();
            ((TransformedInstance)this.getSecond()).delete();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Stress
    extends GaugeVisual {
        public Stress(VisualizationContext context, GaugeBlockEntity blockEntity, float partialTick) {
            super(context, blockEntity, partialTick);
        }

        @Override
        protected Instancer<TransformedInstance> getHeadModel() {
            return this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.GAUGE_HEAD_STRESS));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Speed
    extends GaugeVisual {
        public Speed(VisualizationContext context, GaugeBlockEntity blockEntity, float partialTick) {
            super(context, blockEntity, partialTick);
        }

        @Override
        protected Instancer<TransformedInstance> getHeadModel() {
            return this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.GAUGE_HEAD_SPEED));
        }
    }
}

