/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.mechanicalArm;

import com.google.common.collect.Lists;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.kinetics.base.SingleAxisRotatingVisual;
import com.zurrtum.create.client.content.kinetics.mechanicalArm.ArmRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.AbstractInstance;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10444;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_811;

@Environment(value=EnvType.CLIENT)
public class ArmVisual
extends SingleAxisRotatingVisual<ArmBlockEntity>
implements SimpleDynamicVisual {
    final TransformedInstance base;
    final TransformedInstance lowerBody;
    final TransformedInstance upperBody;
    final TransformedInstance claw;
    private final ArrayList<TransformedInstance> clawGrips;
    private final ArrayList<TransformedInstance> models;
    private final boolean ceiling;
    private final class_4587 poseStack = new class_4587();
    private final class_10444 itemRenderState = new class_10444();
    private boolean wasDancing = false;
    private float baseAngle = Float.NaN;
    private float lowerArmAngle = Float.NaN;
    private float upperArmAngle = Float.NaN;
    private float headAngle = Float.NaN;

    public ArmVisual(VisualizationContext context, ArmBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Models.partial(AllPartialModels.ARM_COG));
        this.base = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_BASE)).createInstance();
        this.lowerBody = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_LOWER_BODY)).createInstance();
        this.upperBody = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_UPPER_BODY)).createInstance();
        this.claw = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(blockEntity.goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE)).createInstance();
        TransformedInstance clawGrip1 = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_CLAW_GRIP_UPPER)).createInstance();
        TransformedInstance clawGrip2 = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ARM_CLAW_GRIP_LOWER)).createInstance();
        this.clawGrips = Lists.newArrayList((Object[])new TransformedInstance[]{clawGrip1, clawGrip2});
        this.models = Lists.newArrayList((Object[])new TransformedInstance[]{this.base, this.lowerBody, this.upperBody, this.claw, clawGrip1, clawGrip2});
        this.ceiling = (Boolean)this.blockState.method_11654((class_2769)ArmBlock.CEILING);
        PoseTransformStack msr = TransformStack.of(this.poseStack);
        msr.translate((class_2382)this.getVisualPosition());
        msr.center();
        if (this.ceiling) {
            msr.rotateXDegrees(180.0f);
        }
        this.animate(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    private void animate(float pt) {
        if (((ArmBlockEntity)this.blockEntity).phase == ArmBlockEntity.Phase.DANCING && ((ArmBlockEntity)this.blockEntity).getSpeed() != 0.0f) {
            this.animateRave(pt);
            this.wasDancing = true;
            return;
        }
        float baseAngleNow = ((ArmBlockEntity)this.blockEntity).baseAngle.getValue(pt);
        float lowerArmAngleNow = ((ArmBlockEntity)this.blockEntity).lowerArmAngle.getValue(pt);
        float upperArmAngleNow = ((ArmBlockEntity)this.blockEntity).upperArmAngle.getValue(pt);
        float headAngleNow = ((ArmBlockEntity)this.blockEntity).headAngle.getValue(pt);
        boolean settled = class_3532.method_15347((float)this.baseAngle, (float)baseAngleNow) && class_3532.method_15347((float)this.lowerArmAngle, (float)lowerArmAngleNow) && class_3532.method_15347((float)this.upperArmAngle, (float)upperArmAngleNow) && class_3532.method_15347((float)this.headAngle, (float)headAngleNow);
        this.baseAngle = baseAngleNow;
        this.lowerArmAngle = lowerArmAngleNow;
        this.upperArmAngle = upperArmAngleNow;
        this.headAngle = headAngleNow;
        if (!settled || this.wasDancing) {
            this.animateArm();
        }
        this.wasDancing = false;
    }

    private void animateRave(float partialTick) {
        int ticks = AnimationTickHolder.getTicks((class_1936)((ArmBlockEntity)this.blockEntity).method_10997());
        float renderTick = (float)ticks + partialTick + (float)(((ArmBlockEntity)this.blockEntity).hashCode() % 64);
        float baseAngle = renderTick * 10.0f % 360.0f;
        float lowerArmAngle = class_3532.method_48781((float)((class_3532.method_15374((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (int)-45, (int)15);
        float upperArmAngle = class_3532.method_48781((float)((class_3532.method_15374((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (int)-45, (int)95);
        float headAngle = -lowerArmAngle;
        int color = Color.rainbowColor(ticks * 100).getRGB();
        this.updateAngles(baseAngle, lowerArmAngle, upperArmAngle, headAngle, color);
    }

    private void animateArm() {
        this.updateAngles(this.baseAngle, this.lowerArmAngle - 135.0f, this.upperArmAngle - 90.0f, this.headAngle, 0xFFFFFF);
    }

    private void updateAngles(float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, int color) {
        boolean isBlockItem;
        class_1799 item;
        boolean hasItem;
        this.poseStack.method_22903();
        PoseTransformStack msr = TransformStack.of(this.poseStack);
        ArmRenderer.transformBase(msr, baseAngle);
        this.base.setTransform(this.poseStack).setChanged();
        ArmRenderer.transformLowerArm(msr, lowerArmAngle);
        this.lowerBody.setTransform(this.poseStack).colorRgb(color).setChanged();
        ArmRenderer.transformUpperArm(msr, upperArmAngle);
        this.upperBody.setTransform(this.poseStack).colorRgb(color).setChanged();
        ArmRenderer.transformHead(msr, headAngle);
        if (this.ceiling && ((ArmBlockEntity)this.blockEntity).goggles) {
            msr.rotateZDegrees(180.0f);
        }
        this.claw.setTransform(this.poseStack).setChanged();
        if (this.ceiling && ((ArmBlockEntity)this.blockEntity).goggles) {
            msr.rotateZDegrees(180.0f);
        }
        boolean bl = hasItem = !(item = ((ArmBlockEntity)this.blockEntity).heldItem).method_7960();
        if (hasItem && item.method_7909() instanceof class_1747) {
            class_310 mc = class_310.method_1551();
            mc.method_65386().method_65598(this.itemRenderState, item, class_811.field_4319, (class_1937)mc.field_1687, null, 0);
            isBlockItem = this.itemRenderState.method_65608();
        } else {
            isBlockItem = false;
        }
        for (int index : Iterate.zeroAndOne) {
            this.poseStack.method_22903();
            int flip = index * 2 - 1;
            ArmRenderer.transformClawHalf(msr, hasItem, isBlockItem, flip);
            this.clawGrips.get(index).setTransform(this.poseStack).setChanged();
            this.poseStack.method_22909();
        }
        this.poseStack.method_22909();
    }

    @Override
    public void update(float pt) {
        super.update(pt);
        this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(((ArmBlockEntity)this.blockEntity).goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE)).stealInstance(this.claw);
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight((FlatLit[])this.models.toArray(FlatLit[]::new));
    }

    @Override
    protected void _delete() {
        super._delete();
        this.models.forEach(AbstractInstance::delete);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        this.models.forEach((Consumer<TransformedInstance>)consumer);
    }
}

