/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.processing.burner;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BlazeBurnerRenderer
implements class_827<BlazeBurnerBlockEntity, BlazeBurnerRenderState> {
    public BlazeBurnerRenderer(class_5614.class_5615 context) {
    }

    public BlazeBurnerRenderState createRenderState() {
        return new BlazeBurnerRenderState();
    }

    public void updateRenderState(BlazeBurnerBlockEntity be, BlazeBurnerRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        BlazeBurnerBlock.HeatLevel heatLevel = be.getHeatLevelForRender();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        class_1937 level = be.method_10997();
        float animation = be.headAnimation.getValue(tickProgress) * 0.175f;
        float horizontalAngle = AngleHelper.rad(be.headAngle.getValue(tickProgress));
        boolean canDrawFlame = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
        boolean drawGoggles = be.goggles;
        PartialModel drawHat = be.hat ? AllPartialModels.TRAIN_HAT : (be.stockKeeper ? AllPartialModels.LOGISTICS_HAT : null);
        int hashCode = be.hashCode();
        state.data = BlazeBurnerRenderer.getBlazeBurnerRenderData(level, state.field_62674, heatLevel, animation, horizontalAngle, canDrawFlame, drawGoggles, drawHat, hashCode);
    }

    public void render(BlazeBurnerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        state.data.render(matrices, queue);
    }

    public static PartialModel getBlazeModel(BlazeBurnerBlock.HeatLevel heatLevel, boolean blockAbove) {
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            return blockAbove ? AllPartialModels.BLAZE_SUPER_ACTIVE : AllPartialModels.BLAZE_SUPER;
        }
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            return blockAbove && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.KINDLED) ? AllPartialModels.BLAZE_ACTIVE : AllPartialModels.BLAZE_IDLE;
        }
        return AllPartialModels.BLAZE_INERT;
    }

    public static void tickAnimation(BlazeBurnerBlockEntity be) {
        boolean active;
        boolean bl = active = be.getHeatLevelFromBlock().isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && be.isValidBlockAbove();
        if (!active) {
            float target = 0.0f;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && !player.method_5767()) {
                double z;
                double x;
                if (be.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.method_23317();
                    z = player.method_23321();
                }
                double dx = x - ((double)be.method_11016().method_10263() + 0.5);
                double dz = z - ((double)be.method_11016().method_10260() + 0.5);
                target = AngleHelper.deg(-class_3532.method_15349((double)dz, (double)dx)) - 90.0f;
            }
            target = be.headAngle.getValue() + AngleHelper.getShortestAngleDiff(be.headAngle.getValue(), target);
            be.headAngle.chase(target, 0.25, LerpedFloat.Chaser.exp(5.0));
            be.headAngle.tickChaser();
        } else {
            be.headAngle.chase((AngleHelper.horizontalAngle(be.method_11010().method_28500((class_2769)BlazeBurnerBlock.field_11177).orElse(class_2350.field_11035)) + 180.0f) % 360.0f, 0.125, LerpedFloat.Chaser.EXP);
            be.headAngle.tickChaser();
        }
        be.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp(0.25));
        be.headAnimation.tickChaser();
    }

    public static BlazeBurnerRenderData getBlazeBurnerRenderData(class_1937 level, class_2680 blockState, BlazeBurnerBlock.HeatLevel heatLevel, float animation, float horizontalAngle, boolean canDrawFlame, boolean drawGoggles, @Nullable PartialModel drawHat, int hashCode) {
        BlazeBurnerRenderData data = new BlazeBurnerRenderData();
        data.layer = class_1921.method_23577();
        data.horizontalAngle = horizontalAngle;
        boolean blockAbove = animation > 0.125f;
        float time = AnimationTickHolder.getRenderTime((class_1936)level);
        float renderTick = time / 16.0f + (float)(hashCode % 13);
        float offsetMult = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = class_3532.method_15374((float)(renderTick % ((float)Math.PI * 2))) / offsetMult;
        float offset1 = class_3532.method_15374((float)((float)(((double)renderTick + Math.PI) % 6.2831854820251465))) / offsetMult;
        float offset2 = class_3532.method_15374((float)((renderTick + 1.5707964f) % ((float)Math.PI * 2))) / offsetMult;
        data.headY = offset - animation * 0.75f;
        PartialModel blazeModel = BlazeBurnerRenderer.getBlazeModel(heatLevel, blockAbove);
        data.blaze = CachedBuffers.partial(blazeModel, blockState);
        if (drawGoggles) {
            PartialModel gogglesModel = blazeModel == AllPartialModels.BLAZE_INERT ? AllPartialModels.BLAZE_GOGGLES_SMALL : AllPartialModels.BLAZE_GOGGLES;
            data.goggles = CachedBuffers.partial(gogglesModel, blockState);
            data.gogglesHeadY = data.headY + 0.5f;
        }
        if (drawHat != null) {
            boolean scale;
            data.hat = new HatRenderState();
            data.hat.scale = scale = blazeModel == AllPartialModels.BLAZE_INERT;
            data.hat.offset = data.headY + (scale ? 0.5f : 0.75f);
            data.hat.layer = class_1921.method_23579();
            data.hat.model = CachedBuffers.partial(drawHat, blockState);
            data.hat.angle = horizontalAngle + (float)Math.PI;
        }
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            PartialModel rodsModel = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
            PartialModel rodsModel2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
            data.rods = CachedBuffers.partial(rodsModel, blockState);
            data.rodsY = offset1 + animation + 0.125f;
            data.rods2 = CachedBuffers.partial(rodsModel2, blockState);
            data.rods2Y = offset2 + animation - 0.1875f;
        }
        if (canDrawFlame && blockAbove) {
            data.flame = new FlameRenderState();
            data.flame.layer = class_1921.method_23579();
            data.flame.model = CachedBuffers.partial(AllPartialModels.BLAZE_BURNER_FLAME, blockState);
            data.flame.angle = horizontalAngle;
            data.flame.spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            class_1058 target = data.flame.spriteShift.getTarget();
            float spriteWidth = target.method_4577() - target.method_4594();
            float spriteHeight = target.method_4575() - target.method_4593();
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            data.flame.vScroll = (float)vScroll;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            data.flame.uScroll = (float)uScroll;
        }
        return data;
    }

    @Environment(value=EnvType.CLIENT)
    public static class BlazeBurnerRenderState
    extends class_11954 {
        public BlazeBurnerRenderData data;
    }

    @Environment(value=EnvType.CLIENT)
    public static class BlazeBurnerRenderData
    implements class_11659.class_11660 {
        public class_1921 layer;
        public float headY;
        public float horizontalAngle;
        public SuperByteBuffer blaze;
        public SuperByteBuffer goggles;
        public float gogglesHeadY;
        public HatRenderState hat;
        public SuperByteBuffer rods;
        public float rodsY;
        public SuperByteBuffer rods2;
        public float rods2Y;
        public FlameRenderState flame;

        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, this.layer, (class_11659.class_11660)this);
            if (this.hat != null) {
                queue.method_73483(matrices, this.hat.layer, (class_11659.class_11660)this.hat);
            }
            if (this.flame != null) {
                queue.method_73483(matrices, this.flame.layer, (class_11659.class_11660)this.flame);
            }
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.blaze.translate(0.0f, this.headY, 0.0f);
            this.blaze.rotateCentered(this.horizontalAngle, class_2350.field_11036);
            this.blaze.light(0xF000F0);
            this.blaze.renderInto(matricesEntry, vertexConsumer);
            if (this.goggles != null) {
                this.goggles.translate(0.0f, this.gogglesHeadY, 0.0f);
                this.goggles.rotateCentered(this.horizontalAngle, class_2350.field_11036);
                this.goggles.light(0xF000F0);
                this.goggles.renderInto(matricesEntry, vertexConsumer);
            }
            if (this.rods != null) {
                this.rods.translate(0.0f, this.rodsY, 0.0f);
                this.rods.light(0xF000F0);
                this.rods.renderInto(matricesEntry, vertexConsumer);
                this.rods2.translate(0.0f, this.rods2Y, 0.0f);
                this.rods2.light(0xF000F0);
                this.rods2.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class HatRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public float angle;
        public boolean scale;
        public float offset;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.model.translate(0.0f, this.offset, 0.0f);
            if (this.scale) {
                this.model.scale(0.75f);
            }
            this.model.rotateCentered(this.angle, class_2350.field_11036);
            this.model.translate(0.5f, 0.0f, 0.5f);
            this.model.light(0xF000F0);
            this.model.renderInto(matricesEntry, vertexConsumer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FlameRenderState
    implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public SpriteShiftEntry spriteShift;
        public float uScroll;
        public float vScroll;
        public float angle;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.model.shiftUVScrolling(this.spriteShift, this.uScroll, this.vScroll);
            this.model.rotateCentered(this.angle, class_2350.field_11036);
            this.model.light(0xF000F0);
            this.model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

