/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.content.schematics.client.tools.ToolType;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class ToolSelectionScreen
extends class_437 {
    public final String scrollToCycle = CreateLang.translateDirect("gui.toolmenu.cycle", new Object[0]).getString();
    public final String holdToFocus = "gui.toolmenu.focusKey";
    protected List<ToolType> tools;
    protected Consumer<ToolType> callback;
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;

    public ToolSelectionScreen(class_310 mc, List<ToolType> tools, Consumer<ToolType> callback) {
        super((class_2561)class_2561.method_43470((String)"Tool Selection"));
        this.field_22787 = mc;
        this.tools = tools;
        this.callback = callback;
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        callback.accept(tools.get(this.selection));
        this.w = Math.max(tools.size() * 50 + 30, 220);
        this.h = 30;
    }

    public void setSelectedElement(ToolType tool) {
        if (!this.tools.contains((Object)tool)) {
            return;
        }
        this.selection = this.tools.indexOf((Object)tool);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(class_332 graphics, float partialTicks) {
        Matrix3x2fStack matrixStack = graphics.method_51448();
        class_1041 mainWindow = this.field_22787.method_22683();
        int scaledWidth = mainWindow.method_4486();
        int scaledHeight = mainWindow.method_4502();
        if (!this.initialized) {
            this.method_25423(this.field_22787, scaledWidth, scaledHeight);
        }
        int x = (scaledWidth - this.w) / 2 + 15;
        int y = scaledHeight - this.h - 75;
        matrixStack.pushMatrix();
        matrixStack.translate(0.0f, -this.yOffset);
        AllGuiTextures gray = AllGuiTextures.HUD_BACKGROUND;
        graphics.method_25291(class_10799.field_56883, gray.location, x - 15, y, (float)gray.getStartX(), (float)gray.getStartY(), this.w, this.h, gray.getWidth(), gray.getHeight(), this.focused ? -520093697 : -2130706433);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<class_2561> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            graphics.method_25291(class_10799.field_56883, gray.location, x - 15, y + 33, (float)gray.getStartX(), (float)gray.getStartY(), this.w, this.h + 22, gray.getWidth(), gray.getHeight(), 0xB2B2CC | stringAlphaComponent);
            if (toolTip.size() > 0) {
                graphics.method_51439(this.field_22793, toolTip.get(0), x - 10, y + 38, 0xEEEEEE | stringAlphaComponent, false);
            }
            if (toolTip.size() > 1) {
                graphics.method_51439(this.field_22793, toolTip.get(1), x - 10, y + 50, 0xCCDDFF | stringAlphaComponent, false);
            }
            if (toolTip.size() > 2) {
                graphics.method_51439(this.field_22793, toolTip.get(2), x - 10, y + 60, 0xCCDDFF | stringAlphaComponent, false);
            }
            if (toolTip.size() > 3) {
                graphics.method_51439(this.field_22793, toolTip.get(3), x - 10, y + 72, 0xCCCCDD | stringAlphaComponent, false);
            }
        }
        if (this.tools.size() > 1) {
            String keyName = AllKeys.TOOL_MENU.method_16007().getString().toUpperCase();
            if (!this.focused) {
                graphics.method_27534(this.field_22793, (class_2561)CreateLang.translateDirect("gui.toolmenu.focusKey", keyName), scaledWidth / 2, y - 10, -3351041);
            } else {
                graphics.method_25300(this.field_22793, this.scrollToCycle, scaledWidth / 2, y - 10, -3351041);
            }
        } else {
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            matrixStack.pushMatrix();
            float f = alpha = this.focused ? 1.0f : 0.2f;
            if (i == this.selection) {
                matrixStack.translate(0.0f, -10.0f);
                graphics.method_25300(this.field_22793, this.tools.get(i).getDisplayName().getString(), x + i * 50 + 24, y + 28, -3351041);
                alpha = 1.0f;
            }
            int color = (int)(alpha * 255.0f) << 24;
            this.tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 12, color);
            this.tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 11, 0xFFFFFF | color);
            matrixStack.popMatrix();
        }
        matrixStack.popMatrix();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(class_332 graphics, float partialTicks) {
        this.draw(graphics, partialTicks);
    }

    public void method_25419() {
        this.callback.accept(this.tools.get(this.selection));
    }

    protected void method_25426() {
        super.method_25426();
        this.initialized = true;
    }
}

