/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.impl;

import com.zurrtum.create.client.flywheel.api.backend.Backend;
import com.zurrtum.create.client.flywheel.impl.FlwConfig;
import com.zurrtum.create.client.flywheel.impl.FlwImpl;
import com.zurrtum.create.client.flywheel.impl.visualization.VisualizationManagerImpl;
import com.zurrtum.create.client.flywheel.lib.backend.SimpleBackend;
import com.zurrtum.create.client.flywheel.lib.util.ResourceUtil;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;
import net.minecraft.class_2960;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class BackendManagerImpl {
    public static final Backend OFF_BACKEND;
    private static Backend backend;

    private BackendManagerImpl() {
    }

    public static Backend currentBackend() {
        return backend;
    }

    public static boolean isBackendOn() {
        return backend != OFF_BACKEND;
    }

    private static ArrayList<Backend> backendsByPriority() {
        ArrayList<Backend> backends = new ArrayList<Backend>(Backend.REGISTRY.getAll());
        backends.sort((a, b) -> Integer.compare(b.priority(), a.priority()));
        return backends;
    }

    public static Backend defaultBackend() {
        ArrayList<Backend> backendsByPriority = BackendManagerImpl.backendsByPriority();
        if (backendsByPriority.isEmpty()) {
            FlwImpl.LOGGER.warn("No backends registered, defaulting to 'flywheel:off'");
            return OFF_BACKEND;
        }
        return backendsByPriority.get(0);
    }

    private static void chooseBackend() {
        Backend preferred = FlwConfig.INSTANCE.backend();
        if (preferred.isSupported()) {
            backend = preferred;
            return;
        }
        ArrayList<Backend> backendsByPriority = BackendManagerImpl.backendsByPriority();
        int startIndex = backendsByPriority.indexOf(preferred) + 1;
        backend = OFF_BACKEND;
        for (int i = startIndex; i < backendsByPriority.size(); ++i) {
            Backend candidate = backendsByPriority.get(i);
            if (!candidate.isSupported()) continue;
            backend = candidate;
            break;
        }
        FlwImpl.LOGGER.warn("Flywheel backend fell back from '{}' to '{}'", (Object)Backend.REGISTRY.getIdOrThrow(preferred), (Object)Backend.REGISTRY.getIdOrThrow(backend));
    }

    public static String getBackendString() {
        class_2960 backendId = Backend.REGISTRY.getId(backend);
        if (backendId == null) {
            return "[unregistered]";
        }
        return backendId.toString();
    }

    public static void init() {
    }

    public static void onEndClientResourceReload(boolean didError) {
        if (didError) {
            return;
        }
        BackendManagerImpl.chooseBackend();
        VisualizationManagerImpl.resetAll();
    }

    public static void onReloadLevelRenderer(class_638 level) {
        BackendManagerImpl.chooseBackend();
        VisualizationManagerImpl.reset((class_1936)level);
    }

    static {
        backend = OFF_BACKEND = SimpleBackend.builder().engineFactory(level -> {
            throw new UnsupportedOperationException("Cannot create engine when backend is off.");
        }).supported(() -> true).register(ResourceUtil.rl("off"));
    }
}

