/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.impl.task;

import com.zurrtum.create.client.flywheel.impl.FlwConfig;
import com.zurrtum.create.client.flywheel.impl.task.ParallelTaskExecutor;
import com.zurrtum.create.client.flywheel.impl.task.SerialTaskExecutor;
import com.zurrtum.create.client.flywheel.impl.task.TaskExecutorImpl;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public final class FlwTaskExecutor {
    private static final AtomicLazy INSTANCE = new AtomicLazy();

    private FlwTaskExecutor() {
    }

    public static TaskExecutorImpl get() {
        return INSTANCE.get();
    }

    private static int getOptimalThreadCount() {
        return class_3532.method_15340((int)Math.max(FlwTaskExecutor.getMaxThreadCount() / 3, FlwTaskExecutor.getMaxThreadCount() - 6), (int)1, (int)10);
    }

    private static int getMaxThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Environment(value=EnvType.CLIENT)
    private static class AtomicLazy {
        private final AtomicReference<AtomicLazy> factory = new AtomicReference();
        private final AtomicReference<TaskExecutorImpl> reference = new AtomicReference();

        private AtomicLazy() {
        }

        public final TaskExecutorImpl get() {
            TaskExecutorImpl result;
            while ((result = this.reference.get()) == null) {
                if (!this.factory.compareAndSet(null, this)) continue;
                this.reference.set(this.initialize());
            }
            return result;
        }

        protected TaskExecutorImpl initialize() {
            int threadCount = FlwConfig.INSTANCE.workerThreads();
            if (threadCount == 0) {
                return SerialTaskExecutor.INSTANCE;
            }
            threadCount = threadCount < 0 ? FlwTaskExecutor.getOptimalThreadCount() : class_3532.method_15340((int)threadCount, (int)1, (int)FlwTaskExecutor.getMaxThreadCount());
            ParallelTaskExecutor executor = new ParallelTaskExecutor("Flywheel", threadCount);
            executor.startWorkers();
            return executor;
        }
    }
}

