/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.backend;

import com.zurrtum.create.client.flywheel.api.backend.Backend;
import com.zurrtum.create.client.flywheel.api.backend.Engine;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class SimpleBackend
implements Backend {
    private final Function<class_1936, Engine> engineFactory;
    private final IntSupplier priority;
    private final BooleanSupplier isSupported;

    public SimpleBackend(Function<class_1936, Engine> engineFactory, IntSupplier priority, BooleanSupplier isSupported) {
        this.engineFactory = engineFactory;
        this.priority = priority;
        this.isSupported = isSupported;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Engine createEngine(class_1936 level) {
        return this.engineFactory.apply(level);
    }

    @Override
    public int priority() {
        return this.priority.getAsInt();
    }

    @Override
    public boolean isSupported() {
        return this.isSupported.getAsBoolean();
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Builder {
        @Nullable
        private Function<class_1936, Engine> engineFactory;
        private IntSupplier priority = () -> 0;
        @Nullable
        private BooleanSupplier isSupported;

        public Builder engineFactory(Function<class_1936, Engine> engineFactory) {
            this.engineFactory = engineFactory;
            return this;
        }

        public Builder priority(int priority) {
            return this.priority(() -> priority);
        }

        public Builder priority(IntSupplier priority) {
            this.priority = priority;
            return this;
        }

        public Builder supported(BooleanSupplier isSupported) {
            this.isSupported = isSupported;
            return this;
        }

        public Backend register(class_2960 id) {
            Objects.requireNonNull(this.engineFactory);
            Objects.requireNonNull(this.isSupported);
            return Backend.REGISTRY.registerAndGet(id, new SimpleBackend(this.engineFactory, this.priority, this.isSupported));
        }
    }
}

