/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual.component;

import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.LineModelBuilder;
import com.zurrtum.create.client.flywheel.lib.visual.component.EntityComponent;
import com.zurrtum.create.client.flywheel.lib.visual.util.SmartRecycler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11631;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public final class HitboxComponent
implements EntityComponent {
    public static final Model BOX_MODEL = new LineModelBuilder(12).line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).line(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f).line(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f).line(0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f).line(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f).line(0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f).line(1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f).line(1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f).line(1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f).build();
    public static final Model LINE_MODEL = new LineModelBuilder(1).line(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f).build();
    private final VisualizationContext context;
    private final class_1297 entity;
    private final SmartRecycler<Model, TransformedInstance> recycler;
    private boolean showEyeBox;

    public HitboxComponent(VisualizationContext context, class_1297 entity) {
        this.context = context;
        this.entity = entity;
        this.showEyeBox = entity instanceof class_1309;
        this.recycler = new SmartRecycler<Model, TransformedInstance>(this::createInstance);
    }

    private TransformedInstance createInstance(Model model) {
        TransformedInstance instance = this.context.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance();
        instance.light(0xF000F0);
        instance.setChanged();
        return instance;
    }

    public boolean doesShowEyeBox() {
        return this.showEyeBox;
    }

    public HitboxComponent showEyeBox(boolean showEyeBox) {
        this.showEyeBox = showEyeBox;
        return this;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        this.recycler.resetCount();
        boolean shouldRenderHitBoxes = class_310.method_1551().field_61504.method_72772(class_11631.field_61581);
        if (shouldRenderHitBoxes && !this.entity.method_5767() && !class_310.method_1551().method_1555()) {
            float partialTick = context.partialTick();
            double entityX = class_3532.method_16436((double)partialTick, (double)this.entity.field_6038, (double)this.entity.method_23317());
            double entityY = class_3532.method_16436((double)partialTick, (double)this.entity.field_5971, (double)this.entity.method_23318());
            double entityZ = class_3532.method_16436((double)partialTick, (double)this.entity.field_5989, (double)this.entity.method_23321());
            class_238 bb = this.entity.method_5829();
            double boxX = entityX + bb.field_1323 - this.entity.method_23317();
            double boxY = entityY + bb.field_1322 - this.entity.method_23318();
            double boxZ = entityZ + bb.field_1321 - this.entity.method_23321();
            float widthX = (float)(bb.field_1320 - bb.field_1323);
            float widthY = (float)(bb.field_1325 - bb.field_1322);
            float widthZ = (float)(bb.field_1324 - bb.field_1321);
            ((TransformedInstance)this.recycler.get(BOX_MODEL).setIdentityTransform().translate(boxX, boxY, boxZ)).scale(widthX, widthY, widthZ).setChanged();
            if (this.showEyeBox) {
                ((TransformedInstance)this.recycler.get(BOX_MODEL).setIdentityTransform().translate(boxX, entityY + (double)this.entity.method_5751() - 0.01, boxZ)).scale(widthX, 0.02f, widthZ).color(255, 0, 0).setChanged();
            }
            class_243 viewVector = this.entity.method_5828(partialTick);
            ((TransformedInstance)this.recycler.get(LINE_MODEL).setIdentityTransform().translate(entityX, entityY + (double)this.entity.method_5751(), entityZ)).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, 1.0f, 0.0f, (float)viewVector.field_1352, (float)viewVector.field_1351, (float)viewVector.field_1350)).color(0, 0, 255).setChanged();
        }
        this.recycler.discardExtra();
    }

    @Override
    public void delete() {
        this.recycler.delete();
    }
}

