/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual.component;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.material.WriteMask;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.vertex.MutableVertexList;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.ShadowInstance;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.QuadMesh;
import com.zurrtum.create.client.flywheel.lib.model.SingleMeshModel;
import com.zurrtum.create.client.flywheel.lib.visual.component.EntityComponent;
import com.zurrtum.create.client.flywheel.lib.visual.util.InstanceRecycler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public final class ShadowComponent
implements EntityComponent {
    private static final class_2960 SHADOW_TEXTURE = class_2960.method_60656((String)"textures/misc/shadow.png");
    private static final Material SHADOW_MATERIAL = SimpleMaterial.builder().texture(SHADOW_TEXTURE).mipmap(false).polygonOffset(true).transparency(Transparency.TRANSLUCENT).writeMask(WriteMask.COLOR).build();
    private static final Model SHADOW_MODEL = new SingleMeshModel(ShadowMesh.INSTANCE, SHADOW_MATERIAL);
    private final VisualizationContext context;
    private final class_1297 entity;
    private final class_1937 level;
    private final class_2338.class_2339 pos = new class_2338.class_2339();
    private final InstanceRecycler<ShadowInstance> instances = new InstanceRecycler<ShadowInstance>(this::createInstance);
    private float radius = 0.0f;
    private float strength = 1.0f;

    public ShadowComponent(VisualizationContext context, class_1297 entity) {
        this.context = context;
        this.entity = entity;
        this.level = entity.method_73183();
    }

    private ShadowInstance createInstance() {
        return this.context.instancerProvider().instancer(InstanceTypes.SHADOW, SHADOW_MODEL).createInstance();
    }

    public float radius() {
        return this.radius;
    }

    public float strength() {
        return this.strength;
    }

    public ShadowComponent radius(float radius) {
        this.radius = Math.min(radius, 32.0f);
        return this;
    }

    public ShadowComponent strength(float strength) {
        this.strength = strength;
        return this;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        this.instances.resetCount();
        boolean shadowsEnabled = (Boolean)class_310.method_1551().field_1690.method_42435().method_41753();
        if (shadowsEnabled && this.radius > 0.0f && !this.entity.method_5767()) {
            this.setupInstances(context);
        }
        this.instances.discardExtra();
    }

    private void setupInstances(DynamicVisual.Context context) {
        double entityX = class_3532.method_16436((double)context.partialTick(), (double)this.entity.field_6038, (double)this.entity.method_23317());
        double entityY = class_3532.method_16436((double)context.partialTick(), (double)this.entity.field_5971, (double)this.entity.method_23318());
        double entityZ = class_3532.method_16436((double)context.partialTick(), (double)this.entity.field_5989, (double)this.entity.method_23321());
        float castDistance = Math.min(this.strength * 2.0f, this.radius);
        int minXPos = class_3532.method_15357((double)(entityX - (double)this.radius));
        int maxXPos = class_3532.method_15357((double)(entityX + (double)this.radius));
        int minYPos = class_3532.method_15357((double)(entityY - (double)castDistance));
        int maxYPos = class_3532.method_15357((double)entityY);
        int minZPos = class_3532.method_15357((double)(entityZ - (double)this.radius));
        int maxZPos = class_3532.method_15357((double)(entityZ + (double)this.radius));
        for (int z = minZPos; z <= maxZPos; ++z) {
            for (int x = minXPos; x <= maxXPos; ++x) {
                this.pos.method_10103(x, 0, z);
                class_2791 chunk = this.level.method_22350((class_2338)this.pos);
                for (int y = minYPos; y <= maxYPos; ++y) {
                    this.pos.method_33098(y);
                    float strengthGivenYFalloff = this.strength - (float)(entityY - (double)this.pos.method_10264()) * 0.5f;
                    this.setupInstance(chunk, this.pos, (float)entityX, (float)entityZ, strengthGivenYFalloff);
                }
            }
        }
    }

    private void setupInstance(class_2791 chunk, class_2338.class_2339 pos, float entityX, float entityZ, float strength) {
        int maxLocalRawBrightness = this.level.method_22339((class_2338)pos);
        if (maxLocalRawBrightness <= 3) {
            return;
        }
        float blockBrightness = class_765.method_23284((class_2874)this.level.method_8597(), (int)maxLocalRawBrightness);
        float alpha = strength * 0.5f * blockBrightness;
        if (alpha < 0.0f) {
            return;
        }
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        pos.method_33098(pos.method_10264() - 1);
        class_265 shape = this.getShapeAt(chunk, (class_2338)pos);
        if (shape == null) {
            return;
        }
        class_2382 renderOrigin = this.context.renderOrigin();
        int x = pos.method_10263() - renderOrigin.method_10263();
        int y = pos.method_10264() - renderOrigin.method_10264() + 1;
        int z = pos.method_10260() - renderOrigin.method_10260();
        double minX = (double)x + shape.method_1091(class_2350.class_2351.field_11048);
        double minY = (double)y + shape.method_1091(class_2350.class_2351.field_11052);
        double minZ = (double)z + shape.method_1091(class_2350.class_2351.field_11051);
        double maxX = (double)x + shape.method_1105(class_2350.class_2351.field_11048);
        double maxZ = (double)z + shape.method_1105(class_2350.class_2351.field_11051);
        ShadowInstance instance = this.instances.get();
        instance.x = (float)minX;
        instance.y = (float)minY;
        instance.z = (float)minZ;
        instance.entityX = entityX - (float)renderOrigin.method_10263();
        instance.entityZ = entityZ - (float)renderOrigin.method_10260();
        instance.sizeX = (float)(maxX - minX);
        instance.sizeZ = (float)(maxZ - minZ);
        instance.alpha = alpha;
        instance.radius = this.radius;
        instance.setChanged();
    }

    @Nullable
    private class_265 getShapeAt(class_2791 chunk, class_2338 pos) {
        class_2680 state = chunk.method_8320(pos);
        if (state.method_26217() == class_2464.field_11455) {
            return null;
        }
        if (!state.method_26234((class_1922)chunk, pos)) {
            return null;
        }
        class_265 shape = state.method_26218((class_1922)chunk, pos);
        if (shape.method_1110()) {
            return null;
        }
        return shape;
    }

    @Override
    public void delete() {
        this.instances.delete();
    }

    @Environment(value=EnvType.CLIENT)
    private static class ShadowMesh
    implements QuadMesh {
        private static final Vector4fc BOUNDING_SPHERE = new Vector4f(0.5f, 0.0f, 0.5f, (float)(Math.sqrt(2.0) * 0.5));
        private static final ShadowMesh INSTANCE = new ShadowMesh();

        private ShadowMesh() {
        }

        @Override
        public int vertexCount() {
            return 4;
        }

        @Override
        public void write(MutableVertexList vertexList) {
            ShadowMesh.writeVertex(vertexList, 0, 0.0f, 0.0f);
            ShadowMesh.writeVertex(vertexList, 1, 0.0f, 1.0f);
            ShadowMesh.writeVertex(vertexList, 2, 1.0f, 1.0f);
            ShadowMesh.writeVertex(vertexList, 3, 1.0f, 0.0f);
        }

        private static void writeVertex(MutableVertexList vertexList, int i, float x, float z) {
            vertexList.x(i, x);
            vertexList.y(i, 0.0f);
            vertexList.z(i, z);
            vertexList.r(i, 1.0f);
            vertexList.g(i, 1.0f);
            vertexList.b(i, 1.0f);
            vertexList.u(i, 0.0f);
            vertexList.v(i, 0.0f);
            vertexList.light(i, 0xF000F0);
            vertexList.overlay(i, class_4608.field_21444);
            vertexList.normalX(i, 0.0f);
            vertexList.normalY(i, 1.0f);
            vertexList.normalZ(i, 0.0f);
        }

        @Override
        public Vector4fc boundingSphere() {
            return BOUNDING_SPHERE;
        }
    }
}

