/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.fluid;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.class_9326;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class FluidRenderer {
    public static void renderFluidStream(class_3611 fluid, class_9326 changes, class_2350 direction, float radius, float progress, boolean inbound, class_4588 builder, class_4587.class_4665 entry, int light) {
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        class_1058 flowTexture = config.flowing().get();
        class_1058 stillTexture = config.still().get();
        int color = config.tint().apply(changes) | 0xFF000000;
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.method_15785().method_15759().method_26213());
        light = light & 0xF00000 | luminosity << 4;
        if (inbound) {
            direction = direction.method_10153();
        }
        entry = entry.method_56822();
        entry.method_67796(0.5f, 0.5f, 0.5f);
        entry.method_67798((Quaternionfc)class_7833.field_40716.rotation((float)Math.PI / 180 * AngleHelper.horizontalAngle(direction)));
        entry.method_67798((Quaternionfc)class_7833.field_40714.rotation((float)Math.PI / 180 * (float)(direction == class_2350.field_11036 ? 180 : (direction == class_2350.field_11033 ? 0 : 270))));
        entry.method_67796(0.0f, -0.5f, 0.0f);
        float hMin = -radius;
        float y = inbound ? 1.0f : 0.5f;
        float yMin = y - class_3532.method_15363((float)(progress * 0.5f), (float)0.0f, (float)1.0f);
        for (int i = 0; i < 4; ++i) {
            FluidRenderer.renderFlowingTiledFace(class_2350.field_11035, hMin, yMin, radius, y, radius, builder, entry, light, color, flowTexture);
            entry.method_67798((Quaternionfc)class_7833.field_40716.rotation(1.5707964f));
        }
        if (progress != 1.0f) {
            FluidRenderHelper.renderStillTiledFace(class_2350.field_11033, hMin, hMin, radius, radius, yMin, builder, entry, light, color, stillTexture);
        }
    }

    public static void renderFlowingTiledFace(class_2350 dir, float left, float down, float right, float up, float depth, class_4588 builder, class_4587.class_4665 entry, int light, int color, class_1058 texture) {
        FluidRenderHelper.renderTiledFace(dir, left, down, right, up, depth, builder, entry, light, color, texture, 0.5f);
    }
}

